/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.ScryersOculusTile;
import com.hollingsworth.arsnouveau.common.items.data.ScryPosData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketMountCamera;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ScryersOculus
extends TickableModBlock {
    public ScryersOculus() {
        this(ScryersOculus.defaultProperties().noOcclusion());
    }

    public ScryersOculus(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pHand == InteractionHand.MAIN_HAND && pLevel.isClientSide) {
            this.openMenu(pLevel, pPos, pPlayer);
        }
        return super.useItemOn(stack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openMenu(Level pLevel, BlockPos pPos, Player pPlayer) {
        ArrayList slots = new ArrayList();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int offset = 3;
        for (BlockPos b : BlockPos.betweenClosed((BlockPos)pPos.offset(offset, -offset, offset), (BlockPos)pPos.offset(-offset, offset, -offset))) {
            ArcanePedestalTile tile;
            BlockEntity blockEntity = pLevel.getBlockEntity(b);
            if (!(blockEntity instanceof ArcanePedestalTile) || !(tile = (ArcanePedestalTile)blockEntity).getStack().is((Item)ItemsRegistry.SCRYER_SCROLL.get())) continue;
            slots.add(new RadialMenuSlot<Item>(tile.getStack().getHoverName().getString(), tile.getStack().getItem(), new ArrayList()));
            stackList.add(tile.getStack());
        }
        if (slots.isEmpty()) {
            PortUtil.sendMessage((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.scryers_eye.no_scrolls"));
            return;
        }
        Minecraft.getInstance().setScreen(new GuiRadialMenu<Item>(new RadialMenu<Item>(scroll -> {
            ScryPosData data = (ScryPosData)((ItemStack)stackList.get(scroll)).get(DataComponentRegistry.SCRY_DATA);
            if (data == null || data.pos().isEmpty()) {
                PortUtil.sendMessage((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.scryers_oculus.no_pos"));
                return;
            }
            Optional<GlobalPos> pos = data.pos();
            pos.ifPresent(globalPos -> Networking.sendToServer(new PacketMountCamera(globalPos.pos())));
        }, slots, (slotData, posestack, positionx, posy, size, transparent) -> RenderUtils.drawItemAsIcon(slotData.getDefaultInstance(), posestack, positionx, posy, size, transparent), 3)).setHoldToOpenGUI(false));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ScryersOculusTile(pPos, pState);
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

