/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.Nook;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class NookModel
extends GeoModel<Nook> {
    public static ResourceLocation TEXTURE = ArsNouveau.prefix("textures/entity/nook.png");
    public static ResourceLocation MODEL = ArsNouveau.prefix("geo/nook.geo.json");
    public static ResourceLocation ANIMATION = ArsNouveau.prefix("animations/nook_animation.json");

    public void setCustomAnimations(Nook entity, long uniqueID, @Nullable AnimationState customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        if (entity.isOrderedToSit()) {
            head.setRotX(extraData.headPitch() * ((float)Math.PI / 180) - 0.567232f);
            head.setRotY(extraData.netHeadYaw() * 0.010453292f);
        } else {
            head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Nook nook) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Nook nook) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(Nook nook) {
        return ANIMATION;
    }
}

