/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.PropParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;

public class LeafParticle
extends PropParticle {
    float rotSpeed;

    public LeafParticle(PropertyParticleOptions propertyParticleOptions, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(propertyParticleOptions, level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetime = 40 + this.random.nextInt(20);
        this.yd = this.yd * 0.7 - 0.015;
        this.xd += (this.random.nextDouble() - 0.5) * 0.005;
        this.zd += (this.random.nextDouble() - 0.5) * 0.005;
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.roll = (float)Math.random() * ((float)Math.PI * 2);
    }

    @Override
    public boolean tinted() {
        return true;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.setColorFromProps();
        if (this.onGround) {
            return;
        }
        float gravity = 0.005f;
        float swayFrequency = 0.05f;
        float swayAmplitude = 0.01f;
        float bobFrequency = 0.15f;
        float bobAmplitude = 0.0015f;
        float horizontalDrag = 0.79f;
        float verticalDrag = 0.89f;
        float phase = (float)(((Object)((Object)this)).hashCode() % 6283) / 1000.0f;
        double swayX = Mth.sin((float)((float)this.age * swayFrequency + phase)) * swayAmplitude;
        double swayZ = Mth.cos((float)((float)this.age * swayFrequency + phase + 1.5707964f)) * swayAmplitude;
        double bobY = Mth.sin((float)((float)this.age * bobFrequency + phase)) * bobAmplitude;
        this.yd -= (double)gravity;
        this.yd += bobY;
        this.xd += swayX;
        this.zd += swayZ;
        this.xd *= (double)horizontalDrag;
        this.yd *= (double)verticalDrag;
        this.zd *= (double)horizontalDrag;
        this.move(this.xd, this.yd, this.zd);
        if (this.onGround) {
            this.xd *= 0.6;
            this.zd *= 0.6;
        }
        this.oRoll = this.roll;
        float rollFrequency = 0.1f;
        float motionMagnitude = Mth.sqrt((float)((float)(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd)));
        float dynamicAmplitude = (float)Mth.clamp((double)((double)motionMagnitude * 2.5), (double)0.1, (double)0.6);
        this.roll = Mth.sin((float)((float)this.age * rollFrequency + phase)) * dynamicAmplitude * 10.0f;
    }

    @Override
    public ParticleColor getDefaultColor() {
        return ParticleColor.GREEN;
    }
}

