/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ColorParticleTypeData
implements ParticleOptions {
    protected ParticleType<? extends ColorParticleTypeData> type;
    public static final MapCodec<ColorParticleTypeData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParticleColor.CODEC.fieldOf("color").forGetter(d -> d.color), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age)).apply((Applicative)instance, ColorParticleTypeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ColorParticleTypeData> STREAM_CODEC = StreamCodec.of(ColorParticleTypeData::toNetwork, ColorParticleTypeData::fromNetwork);
    public ParticleColor color;
    public boolean disableDepthTest;
    public float size = 0.25f;
    public float alpha = 1.0f;
    public int age = 36;

    public static void toNetwork(RegistryFriendlyByteBuf buf, ColorParticleTypeData data) {
        ParticleColor.STREAM.encode((Object)buf, (Object)data.color);
        buf.writeBoolean(data.disableDepthTest);
        buf.writeFloat(data.size);
        buf.writeFloat(data.alpha);
        buf.writeInt(data.age);
    }

    public static ColorParticleTypeData fromNetwork(RegistryFriendlyByteBuf buffer) {
        ParticleColor particleColor = (ParticleColor)ParticleColor.STREAM.decode((Object)buffer);
        boolean disableDepthTest = buffer.readBoolean();
        float size = buffer.readFloat();
        float alpha = buffer.readFloat();
        int age = buffer.readInt();
        return new ColorParticleTypeData(particleColor, disableDepthTest, size, alpha, age);
    }

    public ColorParticleTypeData(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age) {
        this((ParticleType<? extends ColorParticleTypeData>)((ParticleType)ModParticles.GLOW_TYPE.get()), new ParticleColor(r, g, b), disableDepthTest, size, alpha, age);
    }

    public ColorParticleTypeData(ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        this((ParticleType<? extends ColorParticleTypeData>)((ParticleType)ModParticles.GLOW_TYPE.get()), color, disableDepthTest, size, alpha, age);
    }

    public ColorParticleTypeData(ParticleType<? extends ColorParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest) {
        this(particleTypeData, color, disableDepthTest, 0.25f, 1.0f, 36);
    }

    public ColorParticleTypeData(ParticleType<? extends ColorParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        this.type = particleTypeData;
        this.color = color;
        this.disableDepthTest = disableDepthTest;
        this.size = size;
        this.alpha = alpha;
        this.age = age;
    }

    public ParticleType<? extends ColorParticleTypeData> getType() {
        return this.type;
    }
}

