/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.nuggets.client.gui.BaseButton;
import com.hollingsworth.nuggets.client.gui.NuggetImageButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PageHolderScreen
extends BaseDocScreen {
    List<SinglePageWidget> allWidgets = new ArrayList<SinglePageWidget>();
    public SinglePageWidget leftPage = null;
    public SinglePageWidget rightPage = null;
    List<SinglePageCtor> pages;
    public DocEntry entry;

    public PageHolderScreen(DocEntry entry) {
        this.entry = entry;
        this.pages = new ArrayList<SinglePageCtor>(entry.pages());
        this.maxArrowIndex = (this.pages.size() - 1) / 2;
    }

    @Override
    public void init() {
        super.init();
        this.allWidgets = new ArrayList<SinglePageWidget>();
        for (int i = 0; i < this.pages.size(); ++i) {
            SinglePageCtor page = this.pages.get(i);
            SinglePageWidget widget = page.create(this, (i + 1) % 2 == 0 ? this.screenLeft + 153 : this.screenLeft + 19, this.screenTop + 17, 118, 146);
            this.allWidgets.add(widget);
        }
        this.initPages();
    }

    @Override
    public void initBookmarks() {
        super.initBookmarks();
        List<ResourceLocation> bookmarks = DocPlayerData.bookmarks;
        if (bookmarks.size() < 10) {
            BaseButton addBookmark = (BaseButton)this.addRenderableWidget((GuiEventListener)new NuggetImageButton(this.screenLeft + 281, this.screenTop + 1 + 15 * (bookmarks.size() + 1), DocAssets.BOOKMARK.width(), DocAssets.BOOKMARK.height(), DocAssets.BOOKMARK.location(), b -> {
                bookmarks.add(this.entry.id());
                this.initBookmarks();
            }).withTooltip((Component)Component.translatable((String)"ars_nouveau.add_bookmark").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY))));
            this.bookmarkButtons.add(addBookmark);
        }
    }

    @Override
    public void transition(BaseDocScreen screen) {
        super.transition(screen);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        if (this.leftPage != null) {
            this.leftPage.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.rightPage != null) {
            this.rightPage.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void onArrowIndexChange() {
        super.onArrowIndexChange();
        this.rebuildWidgets();
    }

    public void initPages() {
        if (this.leftPage != null) {
            this.removeWidget((GuiEventListener)this.leftPage);
        }
        if (this.rightPage != null) {
            this.removeWidget((GuiEventListener)this.rightPage);
        }
        this.leftPage = null;
        this.rightPage = null;
        if (this.arrowIndex * 2 < this.allWidgets.size()) {
            this.leftPage = this.allWidgets.get(this.arrowIndex * 2);
            this.addRenderableWidget((GuiEventListener)this.leftPage);
        }
        if (this.arrowIndex * 2 + 1 < this.allWidgets.size()) {
            this.rightPage = this.allWidgets.get(this.arrowIndex * 2 + 1);
            this.addRenderableWidget((GuiEventListener)this.rightPage);
        }
    }
}

