/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourceManager;
import com.hollingsworth.arsnouveau.api.source.SourceProvider;
import com.hollingsworth.arsnouveau.common.block.tile.CreativeSourceJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SourceUtil {
    public static List<ISpecialSourceProvider> canGiveSource(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> posList = new ArrayList<ISpecialSourceProvider>();
        for (BlockPos b : BlockPos.withinManhattan((BlockPos)pos, (int)range, (int)range, (int)range)) {
            SourceJarTile jar;
            BlockEntity blockEntity;
            if (!world.isLoaded(b) || !((blockEntity = world.getBlockEntity(b)) instanceof SourceJarTile) || !(jar = (SourceJarTile)blockEntity).canAcceptSource()) continue;
            posList.add(new SourceProvider(jar, b.immutable()));
        }
        List<ISpecialSourceProvider> provider = SourceManager.INSTANCE.canGiveSourceNearby(pos, world, range);
        for (ISpecialSourceProvider p : provider) {
            posList.add(new SourceProvider(p));
        }
        return posList;
    }

    public static List<ISpecialSourceProvider> canTakeSource(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> posList = new ArrayList<ISpecialSourceProvider>();
        for (BlockPos b : BlockPos.withinManhattan((BlockPos)pos, (int)range, (int)range, (int)range)) {
            SourceJarTile jar;
            BlockEntity blockEntity;
            if (!world.isLoaded(b) || !((blockEntity = world.getBlockEntity(b)) instanceof SourceJarTile) || (jar = (SourceJarTile)blockEntity).getSource() <= 0) continue;
            posList.add(new SourceProvider(jar, b.immutable()));
        }
        List<ISpecialSourceProvider> provider = SourceManager.INSTANCE.canTakeSourceNearby(pos, world, range);
        for (ISpecialSourceProvider p : provider) {
            posList.add(new SourceProvider(p));
        }
        return posList;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static ISpecialSourceProvider takeSource(BlockPos pos, Level level, int range, int source) {
        List<ISpecialSourceProvider> providers = SourceUtil.canTakeSource(pos, level, range);
        for (ISpecialSourceProvider provider : providers) {
            if (provider.getSource().getSource() < source) continue;
            provider.getSource().removeSource(source);
            return provider;
        }
        return null;
    }

    @Nullable
    public static List<ISpecialSourceProvider> takeSourceMultiple(BlockPos pos, Level level, int range, int source) {
        List<ISpecialSourceProvider> providers = SourceUtil.canTakeSource(pos, level, range);
        Multimap takenFrom = Multimaps.newMultimap(new HashMap(), ArrayList::new);
        int needed = source;
        for (ISpecialSourceProvider provider : providers) {
            int available;
            int after;
            int initial;
            ISourceTile sourceTile = provider.getSource();
            if (sourceTile instanceof CreativeSourceJarTile) {
                for (Map.Entry entry : takenFrom.entries()) {
                    ((ISpecialSourceProvider)entry.getKey()).getSource().addSource((Integer)entry.getValue());
                }
                return List.of(provider);
            }
            if (needed <= 0 || (initial = sourceTile.getSource()) <= (after = sourceTile.removeSource(available = Math.min(needed, initial)))) continue;
            int extracted = initial - after;
            needed -= extracted;
            takenFrom.put((Object)provider, (Object)extracted);
        }
        if (needed > 0) {
            for (Map.Entry entry : takenFrom.entries()) {
                ((ISpecialSourceProvider)entry.getKey()).getSource().addSource((Integer)entry.getValue());
            }
            return null;
        }
        return new ArrayList<ISpecialSourceProvider>((Collection<ISpecialSourceProvider>)takenFrom.keys());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static ISpecialSourceProvider takeSourceWithParticles(BlockPos pos, Level level, int range, int source) {
        return SourceUtil.takeSourceWithParticles(pos, pos, level, range, source);
    }

    @Nullable
    public static List<ISpecialSourceProvider> takeSourceMultipleWithParticles(BlockPos pos, Level level, int range, int source) {
        return SourceUtil.takeSourceMultipleWithParticles(pos, pos, level, range, source);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static ISpecialSourceProvider takeSourceWithParticles(BlockPos pos, BlockPos particlesTo, Level level, int range, int source) {
        ISpecialSourceProvider result = SourceUtil.takeSource(pos, level, range, source);
        if (result != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityFollowProjectile.spawn(serverLevel, result.getCurrentPos(), particlesTo);
        }
        return result;
    }

    @Nullable
    public static List<ISpecialSourceProvider> takeSourceMultipleWithParticles(BlockPos pos, BlockPos particlesTo, Level level, int range, int source) {
        List<ISpecialSourceProvider> result = SourceUtil.takeSourceMultiple(pos, level, range, source);
        if (result != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ISpecialSourceProvider provider : result) {
                EntityFollowProjectile.spawn(serverLevel, provider.getCurrentPos(), particlesTo);
            }
        }
        return result;
    }

    public static boolean hasSourceNearby(BlockPos pos, Level world, int range, int source) {
        for (ISpecialSourceProvider provider : SourceUtil.canTakeSource(pos, world, range)) {
            ISourceTile sourceTile = provider.getSource();
            if (sourceTile instanceof CreativeSourceJarTile) {
                return true;
            }
            if ((source -= sourceTile.removeSource(source, true)) > 0) continue;
            return true;
        }
        return false;
    }
}

