/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual.features;

import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RandomTreeFeature
implements IPlaceableFeature {
    List<BlockState> treeStates;
    double distance;
    double chance;

    public RandomTreeFeature(List<BlockState> treeStates, double distance, double chance) {
        this.treeStates = treeStates;
        this.distance = distance;
        this.chance = chance;
    }

    @Override
    public double distanceFromOthers() {
        return this.distance;
    }

    @Override
    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        BlockState treeState = this.treeStates.get(level.random.nextInt(this.treeStates.size()));
        if (level.getBlockState(pos).canBeReplaced() && treeState.canSurvive((LevelReader)level, pos)) {
            SaplingBlock saplingBlock;
            level.setBlock(pos, treeState, 3);
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof SaplingBlock) {
                saplingBlock = (SaplingBlock)block;
                saplingBlock.advanceTree((ServerLevel)level, pos, level.getBlockState(pos), level.random);
            }
            if ((block = level.getBlockState(pos).getBlock()) instanceof SaplingBlock) {
                saplingBlock = (SaplingBlock)block;
                saplingBlock.advanceTree((ServerLevel)level, pos, level.getBlockState(pos), level.random);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFeatureName() {
        return "random_tree";
    }
}

