/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual.features;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PlaceBlockFeature
implements IPlaceableFeature {
    public double distance;
    public Supplier<BlockState> block;
    public double chance;

    public PlaceBlockFeature(double distance, double chance, Supplier<BlockState> block) {
        this.distance = distance;
        this.block = block;
        this.chance = chance;
    }

    @Override
    public double distanceFromOthers() {
        return this.distance;
    }

    @Override
    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        BlockState state = this.block.get();
        if ((double)level.random.nextFloat() < this.chance && !level.getBlockState(pos.below()).isAir() && state.canSurvive((LevelReader)level, pos)) {
            Item item = state.getBlock().asItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.place(new BlockPlaceContext(level, (Player)ANFakePlayer.getPlayer((ServerLevel)level), InteractionHand.MAIN_HAND, new ItemStack((ItemLike)blockItem), new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), Direction.DOWN, pos, false)));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFeatureName() {
        return "block";
    }
}

