/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.features.IBlockPosProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class ManhattenTracker
implements IBlockPosProvider {
    public int i;
    public int j;
    public int k;
    public int l;
    public int pXSize;
    public int pYSize;
    public int pZSize;
    public boolean done;
    public final BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
    public int currentDepth;
    public int maxX;
    public int maxY;
    public int x;
    public int y;
    public boolean zMirror;

    public ManhattenTracker(BlockPos pPos, int pXSize, int pYSize, int pZSize) {
        this.i = pXSize + pYSize + pZSize;
        this.j = pPos.getX();
        this.k = pPos.getY();
        this.l = pPos.getZ();
        this.pXSize = pXSize;
        this.pYSize = pYSize;
        this.pZSize = pZSize;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        tag.putInt("i", this.i);
        tag.putInt("j", this.j);
        tag.putInt("k", this.k);
        tag.putInt("l", this.l);
        tag.putInt("pXSize", this.pXSize);
        tag.putInt("pYSize", this.pYSize);
        tag.putInt("pZSize", this.pZSize);
        tag.putBoolean("done", this.done);
        tag.putInt("currentDepth", this.currentDepth);
        tag.putInt("maxX", this.maxX);
        tag.putInt("maxY", this.maxY);
        tag.putInt("x", this.x);
        tag.putInt("y", this.y);
        tag.putBoolean("zMirror", this.zMirror);
        tag.putInt("cursorX", this.cursor.getX());
        tag.putInt("cursorY", this.cursor.getY());
        tag.putInt("cursorZ", this.cursor.getZ());
        return tag;
    }

    public ManhattenTracker(CompoundTag tag) {
        this.i = tag.getInt("i");
        this.j = tag.getInt("j");
        this.k = tag.getInt("k");
        this.l = tag.getInt("l");
        this.pXSize = tag.getInt("pXSize");
        this.pYSize = tag.getInt("pYSize");
        this.pZSize = tag.getInt("pZSize");
        this.done = tag.getBoolean("done");
        this.currentDepth = tag.getInt("currentDepth");
        this.maxX = tag.getInt("maxX");
        this.maxY = tag.getInt("maxY");
        this.x = tag.getInt("x");
        this.y = tag.getInt("y");
        this.zMirror = tag.getBoolean("zMirror");
        this.cursor.set(tag.getInt("cursorX"), tag.getInt("cursorY"), tag.getInt("cursorZ"));
    }

    @Override
    public BlockPos computeNext() {
        if (this.done) {
            return null;
        }
        if (this.zMirror) {
            this.zMirror = false;
            this.cursor.setZ(this.l - (this.cursor.getZ() - this.l));
            return this.cursor;
        }
        BlockPos.MutableBlockPos blockpos = null;
        while (blockpos == null) {
            if (this.y > this.maxY) {
                ++this.x;
                if (this.x > this.maxX) {
                    ++this.currentDepth;
                    if (this.currentDepth > this.i) {
                        this.done = true;
                        return null;
                    }
                    this.maxX = Math.min(this.pXSize, this.currentDepth);
                    this.x = -this.maxX;
                }
                this.maxY = Math.min(this.pYSize, this.currentDepth - Math.abs(this.x));
                this.y = -this.maxY;
            }
            int i1 = this.x;
            int j1 = this.y;
            int k1 = this.currentDepth - Math.abs(i1) - Math.abs(j1);
            if (k1 <= this.pZSize) {
                this.zMirror = k1 != 0;
                blockpos = this.cursor.set(this.j + i1, this.k + j1, this.l + k1);
            }
            ++this.y;
        }
        return blockpos;
    }
}

