/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.registry.GenericRecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;

public class MultiRecipeRegistry<C extends RecipeInput, T extends Recipe<C>> {
    private final List<GenericRecipeRegistry<C, T>> recipeRegistries = new ArrayList<GenericRecipeRegistry<C, T>>();

    public <R extends T> void addRecipeType(Supplier<? extends RecipeType<R>> recipeType) {
        this.recipeRegistries.add(new GenericRecipeRegistry(recipeType));
    }

    public List<RecipeType<? extends T>> getRecipeTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (GenericRecipeRegistry<C, T> registry : this.recipeRegistries) {
            builder.add(registry.getType());
        }
        return builder.build();
    }

    public List<RecipeHolder<? extends T>> getRecipes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (GenericRecipeRegistry<C, T> registry : this.recipeRegistries) {
            builder.addAll(registry.getRecipes());
        }
        return builder.build();
    }
}

