/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface ISpellHotkeyListener {
    default public void onNextKeyPressed(ItemStack stack, ServerPlayer player) {
        AbstractCaster<?> iSpellCaster = SpellCasterRegistry.from(stack);
        ((AbstractCaster)iSpellCaster.setNextSlot()).saveToStack(stack);
    }

    default public void onPreviousKeyPressed(ItemStack stack, ServerPlayer player) {
        AbstractCaster<?> iSpellCaster = SpellCasterRegistry.from(stack);
        ((AbstractCaster)iSpellCaster.setPreviousSlot()).saveToStack(stack);
    }

    default public void onQuickCast(ItemStack stack, ServerPlayer player, InteractionHand hand, int slot) {
        AbstractCaster<?> iSpellCaster = SpellCasterRegistry.from(stack);
        iSpellCaster.castSpell(player.level, (LivingEntity)player, hand, null, iSpellCaster.getSpell(slot));
    }

    @Deprecated(forRemoval=true)
    default public boolean canQuickCast() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onOpenBookMenuKeyPressed(ItemStack stack, Player player) {
    }
}

