/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.entry.PedestalRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;

public class GlyphRecipeEntry
extends PedestalRecipeEntry {
    RecipeHolder<GlyphRecipe> recipe;

    public GlyphRecipeEntry(RecipeHolder<GlyphRecipe> recipe, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.recipe = recipe;
        this.image = DocAssets.SCRIBES_RECIPE;
        this.title = Component.translatable((String)"block.ars_nouveau.scribes_table");
        this.spinning = true;
        this.drawPedestals = false;
        if (recipe != null && recipe.value() != null) {
            this.outputStack = ((GlyphRecipe)recipe.value()).output;
            this.ingredients = ((GlyphRecipe)recipe.value()).inputs;
        }
    }

    public static SinglePageCtor create(RecipeHolder<GlyphRecipe> recipe) {
        return (parent, x, y, width, height) -> new GlyphRecipeEntry(recipe, parent, x, y, width, height);
    }

    @Override
    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        if (this.recipe != null) {
            object.addProperty(DocExporter.RECIPE_PROPERTY, this.recipe.id().toString());
        }
    }
}

