/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.store;

import java.io.EOFException;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.ars_nouveau.store.AlreadyClosedException;
import org.apache.lucene.ars_nouveau.store.DataInput;
import org.apache.lucene.ars_nouveau.store.IndexInput;
import org.apache.lucene.ars_nouveau.store.MemorySegmentAccessInput;
import org.apache.lucene.ars_nouveau.store.NativeAccess;
import org.apache.lucene.ars_nouveau.store.RandomAccessInput;
import org.apache.lucene.ars_nouveau.store.ReadAdvice;
import org.apache.lucene.ars_nouveau.util.ArrayUtil;
import org.apache.lucene.ars_nouveau.util.BitUtil;
import org.apache.lucene.ars_nouveau.util.Constants;
import org.apache.lucene.ars_nouveau.util.GroupVIntUtil;
import org.apache.lucene.ars_nouveau.util.IOConsumer;

abstract class MemorySegmentIndexInput
extends IndexInput
implements RandomAccessInput,
MemorySegmentAccessInput {
    static final ValueLayout.OfByte LAYOUT_BYTE = ValueLayout.JAVA_BYTE;
    static final ValueLayout.OfShort LAYOUT_LE_SHORT = ValueLayout.JAVA_SHORT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    static final ValueLayout.OfInt LAYOUT_LE_INT = ValueLayout.JAVA_INT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    static final ValueLayout.OfLong LAYOUT_LE_LONG = ValueLayout.JAVA_LONG_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    static final ValueLayout.OfFloat LAYOUT_LE_FLOAT = ValueLayout.JAVA_FLOAT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    private static final Optional<NativeAccess> NATIVE_ACCESS = NativeAccess.getImplementation();
    final long length;
    final long chunkSizeMask;
    final int chunkSizePower;
    final boolean confined;
    final Arena arena;
    final MemorySegment[] segments;
    int curSegmentIndex = -1;
    MemorySegment curSegment;
    long curPosition;
    int consecutivePrefetchHitCount;

    public static MemorySegmentIndexInput newInstance(String resourceDescription, Arena arena, MemorySegment[] segments, long length, int chunkSizePower, boolean confined) {
        assert (Arrays.stream(segments).map(MemorySegment::scope).allMatch(arena.scope()::equals));
        if (segments.length == 1) {
            return new SingleSegmentImpl(resourceDescription, arena, segments[0], length, chunkSizePower, confined);
        }
        return new MultiSegmentImpl(resourceDescription, arena, segments, 0L, length, chunkSizePower, confined);
    }

    private MemorySegmentIndexInput(String resourceDescription, Arena arena, MemorySegment[] segments, long length, int chunkSizePower, boolean confined) {
        super(resourceDescription);
        this.arena = arena;
        this.segments = segments;
        this.length = length;
        this.chunkSizePower = chunkSizePower;
        this.confined = confined;
        this.chunkSizeMask = (1L << chunkSizePower) - 1L;
        this.curSegment = segments[0];
    }

    void ensureOpen() {
        if (this.curSegment == null) {
            throw this.alreadyClosed(null);
        }
    }

    void ensureAccessible() {
        if (this.confined && !this.curSegment.isAccessibleBy(Thread.currentThread())) {
            throw new IllegalStateException("confined");
        }
    }

    RuntimeException handlePositionalIOOBE(RuntimeException unused, String action, long pos) throws IOException {
        if (pos < 0L) {
            return new IllegalArgumentException(action + " negative position (pos=" + pos + "): " + String.valueOf(this));
        }
        throw new EOFException(action + " past EOF (pos=" + pos + "): " + String.valueOf(this));
    }

    AlreadyClosedException alreadyClosed(RuntimeException e) {
        if (this.curSegment == null) {
            return new AlreadyClosedException("Already closed: " + String.valueOf(this));
        }
        if (!Arrays.stream(this.segments).allMatch(s -> s.scope().isAlive())) {
            return new AlreadyClosedException("Already closed: " + String.valueOf(this));
        }
        if (e instanceof IllegalStateException && e.getMessage() != null && e.getMessage().contains("closed")) {
            return new AlreadyClosedException("Already closed: " + String.valueOf(this), e);
        }
        throw e;
    }

    @Override
    public final byte readByte() throws IOException {
        try {
            byte v = this.curSegment.get(LAYOUT_BYTE, this.curPosition);
            ++this.curPosition;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            do {
                ++this.curSegmentIndex;
                if (this.curSegmentIndex >= this.segments.length) {
                    throw new EOFException("read past EOF: " + String.valueOf(this));
                }
                this.curSegment = this.segments[this.curSegmentIndex];
                this.curPosition = 0L;
            } while (this.curSegment.byteSize() == 0L);
            byte v = this.curSegment.get(LAYOUT_BYTE, this.curPosition);
            ++this.curPosition;
            return v;
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            MemorySegment.copy(this.curSegment, LAYOUT_BYTE, this.curPosition, b, offset, len);
            this.curPosition += (long)len;
        }
        catch (IndexOutOfBoundsException e) {
            this.readBytesBoundary(b, offset, len);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    private void readBytesBoundary(byte[] b, int offset, int len) throws IOException {
        try {
            long curAvail = this.curSegment.byteSize() - this.curPosition;
            while ((long)len > curAvail) {
                MemorySegment.copy(this.curSegment, LAYOUT_BYTE, this.curPosition, b, offset, (int)curAvail);
                len = (int)((long)len - curAvail);
                offset = (int)((long)offset + curAvail);
                ++this.curSegmentIndex;
                if (this.curSegmentIndex >= this.segments.length) {
                    throw new EOFException("read past EOF: " + String.valueOf(this));
                }
                this.curSegment = this.segments[this.curSegmentIndex];
                this.curPosition = 0L;
                curAvail = this.curSegment.byteSize();
            }
            MemorySegment.copy(this.curSegment, LAYOUT_BYTE, this.curPosition, b, offset, len);
            this.curPosition += (long)len;
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public void readInts(int[] dst, int offset, int length) throws IOException {
        try {
            MemorySegment.copy(this.curSegment, LAYOUT_LE_INT, this.curPosition, dst, offset, length);
            this.curPosition += 4L * (long)length;
        }
        catch (IndexOutOfBoundsException iobe) {
            super.readInts(dst, offset, length);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public void readLongs(long[] dst, int offset, int length) throws IOException {
        try {
            MemorySegment.copy(this.curSegment, LAYOUT_LE_LONG, this.curPosition, dst, offset, length);
            this.curPosition += 8L * (long)length;
        }
        catch (IndexOutOfBoundsException iobe) {
            super.readLongs(dst, offset, length);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public void readFloats(float[] dst, int offset, int length) throws IOException {
        try {
            MemorySegment.copy(this.curSegment, LAYOUT_LE_FLOAT, this.curPosition, dst, offset, length);
            this.curPosition += 4L * (long)length;
        }
        catch (IndexOutOfBoundsException iobe) {
            super.readFloats(dst, offset, length);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public final short readShort() throws IOException {
        try {
            short v = this.curSegment.get(LAYOUT_LE_SHORT, this.curPosition);
            this.curPosition += 2L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return super.readShort();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public final int readInt() throws IOException {
        try {
            int v = this.curSegment.get(LAYOUT_LE_INT, this.curPosition);
            this.curPosition += 4L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return super.readInt();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public final int readVInt() throws IOException {
        return super.readVInt();
    }

    @Override
    public final long readVLong() throws IOException {
        return super.readVLong();
    }

    @Override
    public final long readLong() throws IOException {
        try {
            long v = this.curSegment.get(LAYOUT_LE_LONG, this.curPosition);
            this.curPosition += 8L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return super.readLong();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public long getFilePointer() {
        this.ensureOpen();
        return ((long)this.curSegmentIndex << this.chunkSizePower) + this.curPosition;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ensureOpen();
        int si = (int)(pos >> this.chunkSizePower);
        try {
            if (si != this.curSegmentIndex) {
                MemorySegment seg = this.segments[si];
                this.curSegmentIndex = si;
                this.curSegment = seg;
            }
            this.curPosition = Objects.checkIndex(pos & this.chunkSizeMask, this.curSegment.byteSize() + 1L);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.handlePositionalIOOBE(e, "seek", pos);
        }
    }

    @Override
    public void prefetch(long offset, long length) throws IOException {
        if (NATIVE_ACCESS.isEmpty()) {
            return;
        }
        this.ensureOpen();
        Objects.checkFromIndexSize(offset, length, this.length());
        if (!BitUtil.isZeroOrPowerOfTwo(this.consecutivePrefetchHitCount++)) {
            return;
        }
        NativeAccess nativeAccess = NATIVE_ACCESS.get();
        this.advise(offset, length, segment -> {
            if (!segment.isLoaded()) {
                this.consecutivePrefetchHitCount = 0;
                nativeAccess.madviseWillNeed((MemorySegment)segment);
            }
        });
    }

    @Override
    public void updateReadAdvice(ReadAdvice readAdvice) throws IOException {
        if (NATIVE_ACCESS.isEmpty()) {
            return;
        }
        NativeAccess nativeAccess = NATIVE_ACCESS.get();
        long offset = 0L;
        for (MemorySegment seg : this.segments) {
            this.advise(offset, seg.byteSize(), segment -> nativeAccess.madvise((MemorySegment)segment, readAdvice));
            offset += seg.byteSize();
        }
    }

    void advise(long offset, long length, IOConsumer<MemorySegment> advice) throws IOException {
        if (NATIVE_ACCESS.isEmpty()) {
            return;
        }
        this.ensureOpen();
        Objects.checkFromIndexSize(offset, length, this.length());
        NativeAccess nativeAccess = NATIVE_ACCESS.get();
        try {
            MemorySegment segment = this.segments[(int)(offset >> this.chunkSizePower)];
            if ((offset &= this.chunkSizeMask) + length > segment.byteSize()) {
                length = segment.byteSize() - offset;
            }
            long offsetInPage = (segment.address() + offset) % (long)nativeAccess.getPageSize();
            length += offsetInPage;
            if ((offset -= offsetInPage) < 0L) {
                offset += (long)nativeAccess.getPageSize();
                if ((length -= (long)nativeAccess.getPageSize()) <= 0L) {
                    return;
                }
            }
            MemorySegment advisedSlice = segment.asSlice(offset, length);
            advice.accept(advisedSlice);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EOFException("Read past EOF: " + String.valueOf(this));
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public Optional<Boolean> isLoaded() {
        boolean isLoaded = true;
        for (MemorySegment seg : this.segments) {
            if (seg.isLoaded()) continue;
            isLoaded = false;
            break;
        }
        if (Constants.WINDOWS && !isLoaded) {
            return Optional.empty();
        }
        return Optional.of(isLoaded);
    }

    @Override
    public byte readByte(long pos) throws IOException {
        try {
            int si = (int)(pos >> this.chunkSizePower);
            return this.segments[si].get(LAYOUT_BYTE, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw this.handlePositionalIOOBE(ioobe, "read", pos);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public void readGroupVInt(int[] dst, int offset) throws IOException {
        try {
            int len = GroupVIntUtil.readGroupVInt((DataInput)this, this.curSegment.byteSize() - this.curPosition, p -> this.curSegment.get(LAYOUT_LE_INT, p), this.curPosition, dst, offset);
            this.curPosition += (long)len;
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public void readBytes(long pos, byte[] b, int offset, int len) throws IOException {
        try {
            int si = (int)(pos >> this.chunkSizePower);
            long curAvail = this.segments[si].byteSize() - (pos &= this.chunkSizeMask);
            while ((long)len > curAvail) {
                MemorySegment.copy(this.segments[si], LAYOUT_BYTE, pos, b, offset, (int)curAvail);
                len = (int)((long)len - curAvail);
                offset = (int)((long)offset + curAvail);
                if (++si >= this.segments.length) {
                    throw new EOFException("read past EOF: " + String.valueOf(this));
                }
                pos = 0L;
                curAvail = this.segments[si].byteSize();
            }
            MemorySegment.copy(this.segments[si], LAYOUT_BYTE, pos, b, offset, len);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw this.handlePositionalIOOBE(ioobe, "read", pos);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    private void setPos(long pos, int si) throws IOException {
        try {
            MemorySegment seg = this.segments[si];
            this.curPosition = pos & this.chunkSizeMask;
            this.curSegmentIndex = si;
            this.curSegment = seg;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw this.handlePositionalIOOBE(ioobe, "read", pos);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public short readShort(long pos) throws IOException {
        int si = (int)(pos >> this.chunkSizePower);
        try {
            return this.segments[si].get(LAYOUT_LE_SHORT, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, si);
            return this.readShort();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public int readInt(long pos) throws IOException {
        int si = (int)(pos >> this.chunkSizePower);
        try {
            return this.segments[si].get(LAYOUT_LE_INT, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, si);
            return this.readInt();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public long readLong(long pos) throws IOException {
        int si = (int)(pos >> this.chunkSizePower);
        try {
            return this.segments[si].get(LAYOUT_LE_LONG, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, si);
            return this.readLong();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public final MemorySegmentIndexInput clone() {
        this.ensureOpen();
        this.ensureAccessible();
        MemorySegmentIndexInput clone = this.segments.length == 1 ? new SingleSegmentImpl(this.toString(), null, this.segments[0], this.length, this.chunkSizePower, this.confined) : new MultiSegmentImpl(this.toString(), null, this.segments, ((MultiSegmentImpl)this).offset, this.length, this.chunkSizePower, this.confined);
        try {
            clone.seek(this.getFilePointer());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        return clone;
    }

    @Override
    public final MemorySegmentIndexInput slice(String sliceDescription, long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + String.valueOf(this));
        }
        return this.buildSlice(sliceDescription, offset, length);
    }

    @Override
    public final MemorySegmentIndexInput slice(String sliceDescription, long offset, long length, ReadAdvice advice) throws IOException {
        NativeAccess nativeAccess;
        MemorySegmentIndexInput slice = this.slice(sliceDescription, offset, length);
        if (NATIVE_ACCESS.isPresent() && advice != ReadAdvice.NORMAL && length >= (long)(nativeAccess = NATIVE_ACCESS.get()).getPageSize()) {
            slice.advise(0L, slice.length, segment -> nativeAccess.madvise((MemorySegment)segment, advice));
        }
        return slice;
    }

    MemorySegmentIndexInput buildSlice(String sliceDescription, long offset, long length) {
        MemorySegment[] slices;
        boolean isClone;
        this.ensureOpen();
        this.ensureAccessible();
        boolean bl = isClone = offset == 0L && length == this.length;
        if (isClone) {
            slices = this.segments;
        } else {
            long sliceEnd = offset + length;
            int startIndex = (int)(offset >>> this.chunkSizePower);
            int endIndex = (int)(sliceEnd >>> this.chunkSizePower);
            slices = ArrayUtil.copyOfSubArray(this.segments, startIndex, endIndex + 1);
            slices[slices.length - 1] = slices[slices.length - 1].asSlice(0L, sliceEnd & this.chunkSizeMask);
            offset &= this.chunkSizeMask;
        }
        String newResourceDescription = this.getFullSliceDescription(sliceDescription);
        if (slices.length == 1) {
            return new SingleSegmentImpl(newResourceDescription, null, isClone ? slices[0] : slices[0].asSlice(offset, length), length, this.chunkSizePower, this.confined);
        }
        return new MultiSegmentImpl(newResourceDescription, null, slices, offset, length, this.chunkSizePower, this.confined);
    }

    static boolean checkIndex(long index, long length) {
        return index >= 0L && index < length;
    }

    @Override
    public final void close() throws IOException {
        if (this.curSegment == null) {
            return;
        }
        if (this.arena != null) {
            while (this.arena.scope().isAlive()) {
                try {
                    this.arena.close();
                    break;
                }
                catch (IllegalStateException e) {
                    Thread.onSpinWait();
                }
            }
        }
        this.curSegment = null;
        Arrays.fill(this.segments, null);
    }

    static final class SingleSegmentImpl
    extends MemorySegmentIndexInput {
        SingleSegmentImpl(String resourceDescription, Arena arena, MemorySegment segment, long length, int chunkSizePower, boolean confined) {
            super(resourceDescription, arena, new MemorySegment[]{segment}, length, chunkSizePower, confined);
            this.curSegmentIndex = 0;
        }

        @Override
        public void seek(long pos) throws IOException {
            this.ensureOpen();
            try {
                this.curPosition = Objects.checkIndex(pos, this.length + 1L);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "seek", pos);
            }
        }

        @Override
        public long getFilePointer() {
            this.ensureOpen();
            return this.curPosition;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            try {
                return this.curSegment.get(LAYOUT_BYTE, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public void readBytes(long pos, byte[] bytes, int offset, int length) throws IOException {
            try {
                MemorySegment.copy(this.curSegment, LAYOUT_BYTE, pos, bytes, offset, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public short readShort(long pos) throws IOException {
            try {
                return this.curSegment.get(LAYOUT_LE_SHORT, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public int readInt(long pos) throws IOException {
            try {
                return this.curSegment.get(LAYOUT_LE_INT, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public long readLong(long pos) throws IOException {
            try {
                return this.curSegment.get(LAYOUT_LE_LONG, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public MemorySegment segmentSliceOrNull(long pos, long len) throws IOException {
            try {
                Objects.checkIndex(pos + len, this.length + 1L);
                return this.curSegment.asSlice(pos, len);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "segmentSliceOrNull", pos);
            }
        }
    }

    static final class MultiSegmentImpl
    extends MemorySegmentIndexInput {
        private final long offset;

        MultiSegmentImpl(String resourceDescription, Arena arena, MemorySegment[] segments, long offset, long length, int chunkSizePower, boolean confined) {
            super(resourceDescription, arena, segments, length, chunkSizePower, confined);
            this.offset = offset;
            try {
                this.seek(0L);
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
            assert (this.curSegment != null && this.curSegmentIndex >= 0);
        }

        @Override
        RuntimeException handlePositionalIOOBE(RuntimeException unused, String action, long pos) throws IOException {
            return super.handlePositionalIOOBE(unused, action, pos - this.offset);
        }

        @Override
        public void seek(long pos) throws IOException {
            assert (pos >= 0L) : "negative position";
            super.seek(pos + this.offset);
        }

        @Override
        public long getFilePointer() {
            return super.getFilePointer() - this.offset;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            return super.readByte(pos + this.offset);
        }

        @Override
        public void readBytes(long pos, byte[] bytes, int offset, int length) throws IOException {
            super.readBytes(pos + this.offset, bytes, offset, length);
        }

        @Override
        public short readShort(long pos) throws IOException {
            return super.readShort(pos + this.offset);
        }

        @Override
        public int readInt(long pos) throws IOException {
            return super.readInt(pos + this.offset);
        }

        @Override
        public long readLong(long pos) throws IOException {
            return super.readLong(pos + this.offset);
        }

        @Override
        public MemorySegment segmentSliceOrNull(long pos, long len) throws IOException {
            int si;
            MemorySegment seg;
            if (pos + len > this.length) {
                throw this.handlePositionalIOOBE(null, "segmentSliceOrNull", pos);
            }
            long segOffset = (pos += this.offset) & this.chunkSizeMask;
            if (MultiSegmentImpl.checkIndex(segOffset + len, (seg = this.segments[si = (int)(pos >> this.chunkSizePower)]).byteSize() + 1L)) {
                return seg.asSlice(segOffset, len);
            }
            return null;
        }

        @Override
        MemorySegmentIndexInput buildSlice(String sliceDescription, long ofs, long length) {
            return super.buildSlice(sliceDescription, this.offset + ofs, length);
        }
    }
}

