/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.DocValuesSkipper;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;

public final class DocValuesRangeIterator
extends TwoPhaseIterator {
    private final Approximation approximation = (Approximation)this.approximation();
    private final TwoPhaseIterator innerTwoPhase;

    public DocValuesRangeIterator(TwoPhaseIterator twoPhase, DocValuesSkipper skipper, long lowerValue, long upperValue, boolean queryRangeHasGaps) {
        super(queryRangeHasGaps ? new RangeWithGapsApproximation(twoPhase.approximation(), skipper, lowerValue, upperValue) : new RangeNoGapsApproximation(twoPhase.approximation(), skipper, lowerValue, upperValue));
        this.innerTwoPhase = twoPhase;
    }

    @Override
    public final boolean matches() throws IOException {
        return switch (this.approximation.match.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> true;
            case 2 -> true;
            case 1 -> this.innerTwoPhase.matches();
            case 0 -> throw new IllegalStateException("Unpositioned approximation");
        };
    }

    @Override
    public float matchCost() {
        return this.innerTwoPhase.matchCost();
    }

    private static final class RangeWithGapsApproximation
    extends Approximation {
        RangeWithGapsApproximation(DocIdSetIterator innerApproximation, DocValuesSkipper skipper, long lowerValue, long upperValue) {
            super(innerApproximation, skipper, lowerValue, upperValue);
        }

        @Override
        protected Match match(int level) {
            long minValue = this.skipper.minValue(level);
            long maxValue = this.skipper.maxValue(level);
            if (minValue > this.upperValue || maxValue < this.lowerValue) {
                return Match.NO;
            }
            return Match.MAYBE;
        }
    }

    private static final class RangeNoGapsApproximation
    extends Approximation {
        RangeNoGapsApproximation(DocIdSetIterator innerApproximation, DocValuesSkipper skipper, long lowerValue, long upperValue) {
            super(innerApproximation, skipper, lowerValue, upperValue);
        }

        @Override
        protected Match match(int level) {
            long minValue = this.skipper.minValue(level);
            long maxValue = this.skipper.maxValue(level);
            if (minValue > this.upperValue || maxValue < this.lowerValue) {
                return Match.NO;
            }
            if (minValue >= this.lowerValue && maxValue <= this.upperValue) {
                if (this.skipper.docCount(level) == this.skipper.maxDocID(level) - this.skipper.minDocID(level) + 1) {
                    return Match.YES;
                }
                return Match.IF_DOC_HAS_VALUE;
            }
            return Match.MAYBE;
        }
    }

    static abstract class Approximation
    extends DocIdSetIterator {
        private final DocIdSetIterator innerApproximation;
        protected final DocValuesSkipper skipper;
        protected final long lowerValue;
        protected final long upperValue;
        private int doc = -1;
        Match match = Match.MAYBE;
        int upTo = -1;

        Approximation(DocIdSetIterator innerApproximation, DocValuesSkipper skipper, long lowerValue, long upperValue) {
            this.innerApproximation = innerApproximation;
            this.skipper = skipper;
            this.lowerValue = lowerValue;
            this.upperValue = upperValue;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID() + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            block5: while (true) {
                if (target > this.upTo) {
                    this.skipper.advance(target);
                    target = Math.max(target, this.skipper.minDocID(0));
                    if (target == Integer.MAX_VALUE) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.upTo = this.skipper.maxDocID(0);
                    this.match = this.match(0);
                    for (int nextLevel = 1; this.match != Match.MAYBE && nextLevel < this.skipper.numLevels() && this.match == this.match(nextLevel); ++nextLevel) {
                        this.upTo = this.skipper.maxDocID(nextLevel);
                    }
                }
                switch (this.match.ordinal()) {
                    case 3: {
                        this.doc = target;
                        return this.doc;
                    }
                    case 1: 
                    case 2: {
                        if (target > this.innerApproximation.docID()) {
                            target = this.innerApproximation.advance(target);
                        }
                        if (target > this.upTo) continue block5;
                        this.doc = target;
                        return this.doc;
                    }
                    case 0: {
                        if (this.upTo == Integer.MAX_VALUE) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        target = this.upTo + 1;
                        continue block5;
                    }
                }
                break;
            }
            throw new AssertionError((Object)("Unknown enum constant: " + String.valueOf((Object)this.match)));
        }

        @Override
        public long cost() {
            return this.innerApproximation.cost();
        }

        protected abstract Match match(int var1);
    }

    static enum Match {
        NO,
        MAYBE,
        IF_DOC_HAS_VALUE,
        YES;

    }
}

