/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.queries.intervals.Intervals;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class ContainedBy
extends IntervalFunction {
    private final IntervalFunction big;
    private final IntervalFunction small;

    public ContainedBy(IntervalFunction small, IntervalFunction big) {
        this.small = Objects.requireNonNull(small);
        this.big = Objects.requireNonNull(big);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.containedBy(this.small.toIntervalSource(field, analyzer), this.big.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:containedBy(%s %s)", this.small, this.big);
    }
}

