/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.standard.nodes.intervalfn;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.queries.intervals.Intervals;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class AnalyzedText
extends IntervalFunction {
    private final String term;

    public AnalyzedText(String term) {
        this.term = term;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        int gaps = 0;
        boolean ordered = true;
        try {
            return Intervals.analyzedText(this.term, analyzer, field, gaps, ordered);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        if (AnalyzedText.requiresQuotes(this.term)) {
            return "\"" + this.term + "\"";
        }
        return this.term;
    }

    static boolean requiresQuotes(String term) {
        return Pattern.compile("[\\s]").matcher(term).find();
    }
}

