/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalIterator;
import org.apache.lucene.ars_nouveau.search.ConjunctionUtils;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;

abstract class ConjunctionIntervalIterator
extends IntervalIterator {
    final DocIdSetIterator approximation;
    final List<IntervalIterator> subIterators;
    final float cost;

    ConjunctionIntervalIterator(List<IntervalIterator> subIterators) {
        this.approximation = ConjunctionUtils.intersectIterators(subIterators);
        this.subIterators = subIterators;
        float costsum = 0.0f;
        for (IntervalIterator it : subIterators) {
            costsum += it.matchCost();
        }
        this.cost = costsum;
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        int doc = this.approximation.nextDoc();
        if (doc != Integer.MAX_VALUE) {
            this.reset();
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        int doc = this.approximation.advance(target);
        if (doc != Integer.MAX_VALUE) {
            this.reset();
        }
        return doc;
    }

    protected abstract void reset() throws IOException;

    @Override
    public long cost() {
        return this.approximation.cost();
    }

    @Override
    public final float matchCost() {
        return this.cost;
    }
}

