/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;
import org.apache.lucene.ars_nouveau.search.similarities.TFIDFSimilarity;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class IDFValueSource
extends DocFreqValueSource {
    public IDFValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        super(field, val, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "idf";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        TFIDFSimilarity sim = IDFValueSource.asTFIDF(searcher.getSimilarity(), this.field);
        if (sim == null) {
            throw new UnsupportedOperationException("requires a TFIDFSimilarity (such as ClassicSimilarity)");
        }
        int docfreq = searcher.getIndexReader().docFreq(new Term(this.indexedField, this.indexedBytes));
        float idf = sim.idf(docfreq, searcher.getIndexReader().maxDoc());
        return new DocFreqValueSource.ConstDoubleDocValues(idf, this);
    }

    static TFIDFSimilarity asTFIDF(Similarity sim, String field) {
        while (sim instanceof PerFieldSimilarityWrapper) {
            sim = ((PerFieldSimilarityWrapper)sim).get(field);
        }
        if (sim instanceof TFIDFSimilarity) {
            return (TFIDFSimilarity)sim;
        }
        return null;
    }
}

