/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.hunspell;

import java.util.List;
import org.apache.lucene.ars_nouveau.analysis.hunspell.Dictionary;
import org.apache.lucene.ars_nouveau.util.IntsRef;

class CompoundRule {
    private final char[] data;
    private final Dictionary dictionary;

    CompoundRule(String rule, Dictionary dictionary) {
        this.dictionary = dictionary;
        StringBuilder parsedFlags = new StringBuilder();
        int pos = 0;
        while (pos < rule.length()) {
            int lParen = rule.indexOf(40, pos);
            if (lParen < 0) {
                parsedFlags.append(dictionary.flagParsingStrategy.parseFlags(rule.substring(pos)));
                break;
            }
            parsedFlags.append(dictionary.flagParsingStrategy.parseFlags(rule.substring(pos, lParen)));
            int rParen = rule.indexOf(41, lParen + 1);
            if (rParen < 0) {
                throw new IllegalArgumentException("Unmatched parentheses: " + rule);
            }
            parsedFlags.append(dictionary.flagParsingStrategy.parseFlags(rule.substring(lParen + 1, rParen)));
            pos = rParen + 1;
            if (pos >= rule.length() || rule.charAt(pos) != '?' && rule.charAt(pos) != '*') continue;
            parsedFlags.append(rule.charAt(pos++));
        }
        this.data = parsedFlags.toString().toCharArray();
    }

    boolean mayMatch(List<IntsRef> words) {
        return this.match(words, 0, 0, false);
    }

    boolean fullyMatches(List<IntsRef> words) {
        return this.match(words, 0, 0, true);
    }

    private boolean match(List<IntsRef> words, int patternIndex, int wordIndex, boolean fully) {
        boolean currentWordMatches;
        if (patternIndex >= this.data.length) {
            return wordIndex >= words.size();
        }
        if (wordIndex >= words.size() && !fully) {
            return true;
        }
        char flag = this.data[patternIndex];
        if (patternIndex < this.data.length - 1 && this.data[patternIndex + 1] == '*') {
            int startWI = wordIndex;
            while (wordIndex < words.size() && this.dictionary.hasFlag(words.get(wordIndex), flag)) {
                ++wordIndex;
            }
            while (wordIndex >= startWI) {
                if (this.match(words, patternIndex + 2, wordIndex, fully)) {
                    return true;
                }
                --wordIndex;
            }
            return false;
        }
        boolean bl = currentWordMatches = wordIndex < words.size() && this.dictionary.hasFlag(words.get(wordIndex), flag);
        if (patternIndex < this.data.length - 1 && this.data[patternIndex + 1] == '?') {
            if (currentWordMatches && this.match(words, patternIndex + 2, wordIndex + 1, fully)) {
                return true;
            }
            return this.match(words, patternIndex + 2, wordIndex, fully);
        }
        return currentWordMatches && this.match(words, patternIndex + 1, wordIndex + 1, fully);
    }

    public String toString() {
        return new String(this.data);
    }
}

