/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.particle.timelines.WololoTimeline;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.entity.debug.FixedStack;
import com.hollingsworth.arsnouveau.common.mixin.MobAccessor;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectWololo
extends AbstractEffect {
    public static EffectWololo INSTANCE = new EffectWololo();
    public static int MAX_RECIPE_CACHE = 16;
    public static FixedStack<CraftingRecipe> recipeCache = new FixedStack(MAX_RECIPE_CACHE);
    public static Map<ParticleColor, Item> vanillaColors = new HashMap<ParticleColor, Item>();

    public EffectWololo() {
        super("wololo", "Wololo");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemStack dyeStack = this.getDye(shooter, spellStats, spellContext);
        if (dyeStack.isEmpty()) {
            return;
        }
        DyeItem dye = (DyeItem)dyeStack.getItem();
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            item = itemEntity.getItem().getItem();
            if (item instanceof IDyeable) {
                IDyeable iDyeable = (IDyeable)item;
                iDyeable.onDye(itemEntity.getItem(), dye.getDyeColor());
            } else if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                ItemStack result = this.getDyedResult((ServerLevel)world, EffectWololo.makeContainer(dye, (ItemLike)blockItem));
                result.setCount(itemEntity.getItem().getCount());
                if (!result.isEmpty() && result.getItem() instanceof BlockItem) {
                    itemEntity.setItem(result);
                }
            }
            if (itemEntity.getItem().has(DataComponents.BASE_COLOR)) {
                itemEntity.getItem().set(DataComponents.BASE_COLOR, (Object)dye.getDyeColor());
            }
        } else {
            item = rayTraceResult.getEntity();
            if (item instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)item;
                if (living instanceof Sheep) {
                    Sheep sheep = (Sheep)living;
                    sheep.setColor(dye.getDyeColor());
                } else if (spellStats.isSensitive() || living instanceof ArmorStand) {
                    for (ItemStack armorStack : living.getArmorSlots()) {
                        if (armorStack.isEmpty()) continue;
                        DyedItemColor dyeComponent = (DyedItemColor)armorStack.get(DataComponents.DYED_COLOR);
                        if (dyeComponent != null) {
                            armorStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(dye.getDyeColor().getTextureDiffuseColor(), false));
                        } else {
                            Item item = armorStack.getItem();
                            if (item instanceof IDyeable) {
                                IDyeable iDyeable = (IDyeable)item;
                                iDyeable.onDye(armorStack, dye.getDyeColor());
                            }
                        }
                        if (!armorStack.has(DataComponents.BASE_COLOR)) continue;
                        armorStack.set(DataComponents.BASE_COLOR, (Object)dye.getDyeColor());
                    }
                } else if (living instanceof Mob) {
                    Mob mob = (Mob)living;
                    ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)world);
                    player.setItemInHand(InteractionHand.MAIN_HAND, dyeStack);
                    ((MobAccessor)mob).callMobInteract((Player)player, InteractionHand.MAIN_HAND);
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                }
            }
        }
        world.playSound(null, rayTraceResult.getEntity().getX(), rayTraceResult.getEntity().getY(), rayTraceResult.getEntity().getZ(), SoundEvents.EVOKER_PREPARE_WOLOLO, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @NotNull
    private ItemStack getDye(@NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (spellContext.getCaster() instanceof TileCaster) {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            SlotReference reference = manager.findItem(i -> i.getItem() instanceof DyeItem, InteractType.EXTRACT);
            if (!reference.isEmpty()) {
                return reference.getHandler().getStackInSlot(reference.getSlot());
            }
        } else {
            ItemStack stack = shooter.getOffhandItem();
            if (stack.getItem() instanceof DyeItem) {
                return stack;
            }
        }
        DyeItem dye = spellStats.isRandomized() ? this.getRandomDye(shooter.getRandom()) : EffectWololo.getDyeItemFromSpell(spellContext);
        return dye.getDefaultInstance();
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos blockPos = rayTraceResult.getBlockPos();
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof IWololoable) {
            IWololoable tileToDye = (IWololoable)blockEntity;
            ParticleColor color = spellStats.isRandomized() ? ParticleColor.makeRandomColor(255, 255, 255, shooter.getRandom()) : spellContext.getSpell().color();
            tileToDye.setColor(color);
        } else {
            ItemStack dyeStack = this.getDye(shooter, spellStats, spellContext);
            if (dyeStack.isEmpty()) {
                return;
            }
            DyeItem dye = (DyeItem)dyeStack.getItem();
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                Player player = this.getPlayer(shooter, (ServerLevel)world);
                dye.tryApplyToSign(world, sign, sign.isFacingFrontText(player), player);
            } else {
                BlockState hitBlock = world.getBlockState(blockPos);
                if (hitBlock.isAir()) {
                    return;
                }
                ItemStack result = this.getDyedResult((ServerLevel)world, EffectWololo.makeContainer(dye, (ItemLike)hitBlock.getBlock()));
                if (!(!result.isEmpty() && result.getItem() instanceof BlockItem || !(result = this.getDyedResult((ServerLevel)world, EffectWololo.makeContainer8(dye, hitBlock.getBlock()))).isEmpty() && result.getItem() instanceof BlockItem)) {
                    return;
                }
                BlockItem blockItem = (BlockItem)result.getItem();
                BlockState newState = blockItem.getBlock().withPropertiesOf(hitBlock);
                world.setBlockAndUpdate(blockPos, newState);
            }
        }
    }

    @NotNull
    private ItemStack getDyedResult(ServerLevel world, CraftingContainer craftingcontainer) {
        Optional<CraftingRecipe> recipe = recipeCache.stream().filter(craftingRecipe -> craftingRecipe.matches((RecipeInput)craftingcontainer.asCraftInput(), (Level)world)).findFirst();
        if (recipe.isPresent()) {
            recipeCache.add(recipe.get());
            return recipe.get().assemble((RecipeInput)craftingcontainer.asCraftInput(), (HolderLookup.Provider)world.registryAccess());
        }
        return world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingcontainer.asCraftInput(), (Level)world).map(craftingRecipe -> ((CraftingRecipe)craftingRecipe.value()).assemble((RecipeInput)craftingcontainer.asCraftInput(), (HolderLookup.Provider)world.registryAccess())).orElse(ItemStack.EMPTY);
    }

    private static CraftingContainer makeContainer(DyeItem targetColor, ItemLike blockToDye) {
        TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            @NotNull
            public ItemStack quickMoveStack(@NotNull Player p_218264_, int p_218265_) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(@NotNull Player p_29888_) {
                return false;
            }
        }, 2, 1);
        craftingcontainer.setItem(0, new ItemStack((ItemLike)targetColor));
        craftingcontainer.setItem(1, new ItemStack(blockToDye));
        return craftingcontainer;
    }

    private static CraftingContainer makeContainer8(DyeItem targetColor, Block blockToDye) {
        TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            @NotNull
            public ItemStack quickMoveStack(@NotNull Player p_218264_, int p_218265_) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(@NotNull Player p_29888_) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingcontainer.setItem(i, i == 4 ? new ItemStack((ItemLike)targetColor) : new ItemStack((ItemLike)blockToDye));
        }
        return craftingcontainer;
    }

    private DyeItem getRandomDye(RandomSource random) {
        return (DyeItem)vanillaColors.values().toArray()[random.nextInt(vanillaColors.size())];
    }

    private static DyeItem getDyeItemFromSpell(SpellContext spellContext) {
        ParticleColor spellColor = ((WololoTimeline)spellContext.getSpell().particleTimeline().get(ParticleTimelineRegistry.WOLOLO_TIMELINE)).getColor();
        ParticleColor targetColor = vanillaColors.keySet().stream().min(Comparator.comparingDouble(d -> d.euclideanDistance(spellColor))).orElse(ParticleColor.WHITE);
        return (DyeItem)vanillaColors.get(targetColor);
    }

    @Override
    protected int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentRandomize.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put(AugmentRandomize.INSTANCE, "Randomizes the color of the dye used.");
        map.put(AugmentSensitive.INSTANCE, "Dyes the targets armor.");
    }

    @Override
    public String getBookDescription() {
        return "Changes the color of an entity or compatible block to the color of the spell.";
    }

    static {
        vanillaColors.put(ParticleColor.WHITE, Items.WHITE_DYE);
        vanillaColors.put(ParticleColor.RED, Items.RED_DYE);
        vanillaColors.put(ParticleColor.GREEN, Items.GREEN_DYE);
        vanillaColors.put(ParticleColor.BLUE, Items.BLUE_DYE);
        vanillaColors.put(ParticleColor.YELLOW, Items.YELLOW_DYE);
        vanillaColors.put(ParticleColor.PURPLE, Items.PURPLE_DYE);
        vanillaColors.put(ParticleColor.CYAN, Items.CYAN_DYE);
        vanillaColors.put(ParticleColor.ORANGE, Items.ORANGE_DYE);
        vanillaColors.put(ParticleColor.MAGENTA, Items.MAGENTA_DYE);
        vanillaColors.put(ParticleColor.LIGHT_BLUE, Items.LIGHT_BLUE_DYE);
        vanillaColors.put(ParticleColor.LIME, Items.LIME_DYE);
        vanillaColors.put(ParticleColor.PINK, Items.PINK_DYE);
        vanillaColors.put(ParticleColor.GRAY, Items.GRAY_DYE);
        vanillaColors.put(ParticleColor.LIGHT_GRAY, Items.LIGHT_GRAY_DYE);
        vanillaColors.put(ParticleColor.BROWN, Items.BROWN_DYE);
        vanillaColors.put(ParticleColor.BLACK, Items.BLACK_DYE);
    }
}

