/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketHotkeyPressed
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketHotkeyPressed> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("hotkey_pressed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketHotkeyPressed> CODEC = StreamCodec.ofMember(PacketHotkeyPressed::toBytes, PacketHotkeyPressed::new);
    Key key;

    public PacketHotkeyPressed(Key key) {
        this.key = key;
    }

    public PacketHotkeyPressed(RegistryFriendlyByteBuf buf) {
        this.key = Key.valueOf(buf.readUtf());
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.key.name());
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        InteractionHand hand = StackUtil.getHeldCasterTool((Player)player, tool -> tool.getMaxSlots() > 1);
        if (hand == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof ISpellHotkeyListener)) {
            return;
        }
        ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)item;
        if (this.key == Key.NEXT) {
            hotkeyListener.onNextKeyPressed(stack, player);
        } else if (this.key == Key.PREVIOUS) {
            hotkeyListener.onPreviousKeyPressed(stack, player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Key {
        NEXT,
        PREVIOUS;

    }
}

