/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.DiveAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.FlyHelper;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.StartFlightGoal;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildenStalker
extends Monster
implements GeoEntity {
    int leapCooldown;
    public Vec3 orbitOffset = Vec3.ZERO;
    public BlockPos orbitPosition = BlockPos.ZERO;
    public static final EntityDataAccessor<Boolean> isFlying = SynchedEntityData.defineId(WildenStalker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int timeFlying;
    AnimationController<WildenStalker> flyController;
    AnimationController<WildenStalker> groundController;
    AnimationController<WildenStalker> idleController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WildenStalker(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyHelper(this);
    }

    public WildenStalker(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_STALKER.get()), worldIn);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new StartFlightGoal(this));
        this.goalSelector.addGoal(1, (Goal)new DiveAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.STALKER_ATTACK_ANIMALS.get()).booleanValue()) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.isFlying() && this.onGround()) {
                this.setFlying(false);
            }
            this.timeFlying = this.isFlying() ? ++this.timeFlying : 0;
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (!this.level.isClientSide && entityIn instanceof LivingEntity && this.level.getDifficulty() == Difficulty.HARD) {
            ((LivingEntity)entityIn).addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 0));
        }
        return super.doHurtTarget(entityIn);
    }

    protected int calculateFallDamage(float distance, float damageMultiplier) {
        return 0;
    }

    public int getLeapCooldown() {
        return this.leapCooldown;
    }

    public void setLeapCooldown(int leapCooldown) {
        this.leapCooldown = leapCooldown;
    }

    public int getBaseExperienceReward() {
        return 8;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    private PlayState flyPredicate(AnimationState event) {
        if (this.isFlying()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fly"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState groundPredicate(AnimationState e) {
        if (this.isFlying()) {
            return PlayState.STOP;
        }
        if (e.isMoving()) {
            e.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        this.flyController = new AnimationController((GeoAnimatable)this, "flyController", 1, this::flyPredicate);
        animatableManager.add(this.flyController);
        this.groundController = new AnimationController((GeoAnimatable)this, "groundController", 1, this::groundPredicate);
        animatableManager.add(this.groundController);
        this.idleController = new AnimationController((GeoAnimatable)this, "idleController", 1, this::idlePredicate);
        animatableManager.add(this.idleController);
    }

    private <T extends GeoAnimatable> PlayState idlePredicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving() || this.isFlying()) {
            return PlayState.STOP;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.checkFallDamage(y, onGroundIn, state, pos);
        }
    }

    public void travel(Vec3 travelVector) {
        if (!this.isFlying()) {
            super.travel(travelVector);
            return;
        }
        if (this.isInWater()) {
            this.moveRelative(0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            BlockPos ground = BlockPos.containing((double)this.getX(), (double)(this.getY() - 1.0), (double)this.getZ());
            float f = 0.91f;
            if (this.onGround()) {
                f = this.level.getBlockState(ground).getFriction((LevelReader)this.level, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.onGround()) {
                f = this.level.getBlockState(ground).getFriction((LevelReader)this.level, ground, (Entity)this) * 0.91f;
            }
            this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
        }
        this.calculateEntityAnimation(false);
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_KNOCKBACK, 0.7).add(Attributes.ATTACK_DAMAGE, 2.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(isFlying, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(isFlying);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(isFlying, (Object)flying);
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        this.setFlying(pCompound.getBoolean("isFlying"));
    }

    public boolean save(CompoundTag pCompound) {
        pCompound.putBoolean("isFlying", this.isFlying());
        return super.save(pCompound);
    }

    public static enum Animations {
        ATTACK,
        DIVE,
        FLY;

    }
}

