/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ExtendableShapelessSerializer {
    public static <T extends ShapelessRecipe> RecipeSerializer<T> create(final ShapelessConstructor<T> creator) {
        return new RecipeSerializer<T>(){
            public final MapCodec<T> CODEC;
            public final StreamCodec<RegistryFriendlyByteBuf, T> STREAM_CODEC;
            {
                this.CODEC = ExtendableShapelessSerializer.createMap(creator);
                this.STREAM_CODEC = ExtendableShapelessSerializer.createStream(creator);
            }

            public MapCodec<T> codec() {
                return this.CODEC;
            }

            public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
                return this.STREAM_CODEC;
            }
        };
    }

    public static <T extends ShapelessRecipe> MapCodec<T> createMap(ShapelessConstructor<T> create) {
        return RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)p_340779_, create::create));
    }

    public static <T extends ShapelessRecipe> StreamCodec<RegistryFriendlyByteBuf, T> createStream(ShapelessConstructor<T> create) {
        return StreamCodec.of(ExtendableShapelessSerializer::toNetwork, a -> ExtendableShapelessSerializer.fromNetwork(a, create));
    }

    private static <T extends ShapelessRecipe> T fromNetwork(RegistryFriendlyByteBuf p_319905_, ShapelessConstructor<T> create) {
        String s = p_319905_.readUtf();
        CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319905_.readEnum(CraftingBookCategory.class);
        int i = p_319905_.readVarInt();
        NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
        nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_319905_));
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319905_);
        return (T)((ShapelessRecipe)create.create(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist));
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320371_, ShapelessRecipe p_320323_) {
        p_320371_.writeUtf(p_320323_.getGroup());
        p_320371_.writeEnum((Enum)p_320323_.category());
        p_320371_.writeVarInt(p_320323_.getIngredients().size());
        for (Ingredient ingredient : p_320323_.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320371_, (Object)ingredient);
        }
        ItemStack.STREAM_CODEC.encode((Object)p_320371_, (Object)p_320323_.getResultItem(null));
    }

    @FunctionalInterface
    public static interface ShapelessConstructor<T> {
        public T create(String var1, CraftingBookCategory var2, ItemStack var3, NonNullList<Ingredient> var4);
    }
}

