/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public class EnchantingApparatusRecipe
implements IEnchantingRecipe {
    private final Ingredient reagent;
    private final ItemStack result;
    private final List<Ingredient> pedestalItems;
    private final int sourceCost;
    private final boolean keepNbtOfReagent;
    private NonNullList<Ingredient> ingredients;

    public EnchantingApparatusRecipe(Ingredient reagent, ItemStack result, List<Ingredient> pedestalItems, int sourceCost, boolean keepNbtOfReagent) {
        this.reagent = reagent;
        this.result = result;
        this.pedestalItems = pedestalItems;
        this.sourceCost = sourceCost;
        this.keepNbtOfReagent = keepNbtOfReagent;
        this.ingredients = NonNullList.createWithCapacity((int)(pedestalItems.size() + 1));
        this.ingredients.add((Object)reagent);
        this.ingredients.addAll(pedestalItems);
    }

    public boolean excludeJei() {
        return false;
    }

    @Override
    public boolean matches(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        if (this.pedestalItems.size() != input.pedestals().size()) {
            return false;
        }
        return this.doesReagentMatch(input, level, player) && this.doPedestalsMatch(input);
    }

    public boolean doPedestalsMatch(ApparatusRecipeInput input) {
        if (this.pedestalItems.size() != input.pedestals().size()) {
            return false;
        }
        List<ItemStack> pedestalItems = input.pedestals().stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        return EnchantingApparatusRecipe.doItemsMatch(pedestalItems, this.pedestalItems);
    }

    public boolean doesReagentMatch(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        return this.reagent.test(input.catalyst());
    }

    public static boolean doItemsMatch(List<ItemStack> inputs, List<Ingredient> recipeItems) {
        if (inputs.size() != recipeItems.size()) {
            return false;
        }
        StackedContents recipeitemhelper = new StackedContents();
        for (ItemStack i : inputs) {
            recipeitemhelper.accountStack(i, 1);
        }
        return RecipeMatcher.findMatches(inputs, recipeItems) != null;
    }

    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_346030_) {
        ItemStack result = this.result.copy();
        ItemStack reagent = input.catalyst();
        if (this.keepNbtOfReagent) {
            result.applyComponents(reagent.getComponentsPatch());
            if (result.has(DataComponents.DAMAGE)) {
                result.setDamageValue(0);
            }
        }
        return result.copy();
    }

    @Override
    public boolean consumesSource() {
        return this.sourceCost() > 0;
    }

    @Override
    public int sourceCost() {
        return this.sourceCost;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.APPARATUS_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.APPARATUS_TYPE.get();
    }

    public Ingredient reagent() {
        return this.reagent;
    }

    public ItemStack result() {
        return this.result;
    }

    public List<Ingredient> pedestalItems() {
        return this.pedestalItems;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean keepNbtOfReagent() {
        return this.keepNbtOfReagent;
    }

    public static class Serializer
    implements RecipeSerializer<EnchantingApparatusRecipe> {
        public static MapCodec<EnchantingApparatusRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(EnchantingApparatusRecipe::reagent), (App)ItemStack.CODEC.fieldOf("result").forGetter(EnchantingApparatusRecipe::result), (App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost), (App)Codec.BOOL.fieldOf("keepNbtOfReagent").forGetter(EnchantingApparatusRecipe::keepNbtOfReagent)).apply((Applicative)instance, EnchantingApparatusRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, EnchantingApparatusRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantingApparatusRecipe::reagent, (StreamCodec)ItemStack.STREAM_CODEC, EnchantingApparatusRecipe::result, ANCodecs.INGREDIENT_LIST_STREAM, EnchantingApparatusRecipe::pedestalItems, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantingApparatusRecipe::sourceCost, (StreamCodec)ByteBufCodecs.BOOL, EnchantingApparatusRecipe::keepNbtOfReagent, EnchantingApparatusRecipe::new);

        @NotNull
        public MapCodec<EnchantingApparatusRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, EnchantingApparatusRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

