/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class SourceStorage
implements ISourceCap,
INBTSerializable<Tag> {
    protected int source;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public SourceStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public SourceStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public SourceStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public SourceStorage(int capacity, int maxReceive, int maxExtract, int source) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.source = Math.max(0, Math.min(capacity, source));
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    @Override
    public int getMaxExtract() {
        return this.maxExtract;
    }

    @Override
    public int getMaxReceive() {
        return this.maxReceive;
    }

    @Override
    public void setSource(int source) {
        this.source = Math.clamp((long)source, 0, this.capacity);
    }

    @Override
    public int receiveSource(int toReceive, boolean simulate) {
        if (!this.canReceive() || toReceive <= 0) {
            return 0;
        }
        int sourceReceived = Mth.clamp((int)(this.capacity - this.source), (int)0, (int)Math.min(this.maxReceive, toReceive));
        if (!simulate) {
            this.source += sourceReceived;
            this.onContentsChanged();
        }
        return sourceReceived;
    }

    @Override
    public int extractSource(int toExtract, boolean simulate) {
        if (!this.canExtract() || toExtract <= 0) {
            return 0;
        }
        int sourceExtracted = Math.min(this.source, Math.min(this.maxExtract, toExtract));
        if (!simulate) {
            this.source -= sourceExtracted;
            this.onContentsChanged();
        }
        return sourceExtracted;
    }

    @Override
    public int getSource() {
        return this.source;
    }

    @Override
    public void setMaxSource(int max) {
        this.capacity = max;
    }

    @Override
    public int getSourceCapacity() {
        return this.capacity;
    }

    @Override
    public boolean canAcceptSource(int source) {
        return this.receiveSource(source, true) > 0;
    }

    @Override
    public boolean canProvideSource(int source) {
        return this.extractSource(source, true) > 0;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public Tag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return IntTag.valueOf((int)this.getSource());
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.source = intNbt.getAsInt();
    }

    public void onContentsChanged() {
    }
}

