/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RelayTile
extends AbstractSourceMachine
implements ITooltipProvider,
IWandable,
GeoBlockEntity,
ITickable {
    private BlockPos toPos;
    private BlockPos fromPos;
    public boolean disabled;
    String TO = "to_";
    String FROM = "from";
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RelayTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.ARCANE_RELAY_TILE.get(), pos, state);
    }

    public RelayTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockPos getToPos() {
        return this.toPos;
    }

    public void setToPos(BlockPos toPos) {
        this.toPos = toPos;
    }

    public BlockPos getFromPos() {
        return this.fromPos;
    }

    public void setFromPos(BlockPos fromPos) {
        this.fromPos = fromPos;
    }

    public boolean setTakeFrom(BlockPos pos) {
        if (BlockUtil.distanceFrom(pos, this.worldPosition) > (double)this.getMaxDistance() || pos.equals((Object)this.getBlockPos())) {
            return false;
        }
        this.fromPos = pos;
        this.updateBlock();
        return true;
    }

    public boolean setSendTo(BlockPos pos) {
        if (BlockUtil.distanceFrom(pos, this.worldPosition) > (double)this.getMaxDistance() || pos.equals((Object)this.getBlockPos())) {
            return false;
        }
        if (!(this.level.getBlockEntity(pos) instanceof AbstractSourceMachine) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, pos, null) == null) {
            return false;
        }
        this.toPos = pos;
        this.updateBlock();
        return true;
    }

    public int getMaxDistance() {
        return 30;
    }

    public void clearPos() {
        this.toPos = null;
        this.fromPos = null;
        this.updateBlock();
    }

    @Override
    @NotNull
    protected SourceStorage createDefaultStorage() {
        return new SourceStorage(1000, 1000);
    }

    public boolean closeEnough(BlockPos pos) {
        return BlockUtil.distanceFrom(pos, this.worldPosition) <= (double)this.getMaxDistance() && !pos.equals((Object)this.getBlockPos());
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.level.isClientSide || storedPos.equals((Object)this.getBlockPos())) {
            return;
        }
        if (!(this.level.getBlockEntity(storedPos) instanceof AbstractSourceMachine) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, storedPos, null) == null) {
            return;
        }
        if (this.setSendTo(storedPos.immutable())) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.send", (Object[])new Object[]{DominionWand.getPosString(storedPos)}));
            ParticleUtil.beam(storedPos, this.worldPosition, this.level);
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.fail"));
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || storedPos.equals((Object)this.getBlockPos()) || this.level.getBlockEntity(storedPos) instanceof RelayTile) {
            return;
        }
        if (!(this.level.getBlockEntity(storedPos) instanceof AbstractSourceMachine) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, storedPos, null) == null) {
            return;
        }
        if (this.setTakeFrom(storedPos.immutable())) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.take", (Object[])new Object[]{DominionWand.getPosString(storedPos)}));
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.fail"));
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.clearPos();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.cleared"));
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.toPos != null) {
            list.add(ColorPos.centered(this.toPos, ParticleColor.TO_HIGHLIGHT));
        }
        if (this.fromPos != null) {
            list.add(ColorPos.centered(this.fromPos, ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    @Override
    public void tick() {
        ISourceCap sourceHandler;
        Object object;
        if (this.level.isClientSide || this.disabled) {
            return;
        }
        if (this.level.getGameTime() % 20L != 0L) {
            return;
        }
        if (this.fromPos != null && this.level.isLoaded(this.fromPos)) {
            if (!(this.level.getBlockEntity(this.fromPos) instanceof AbstractSourceMachine) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.fromPos, null) == null) {
                this.fromPos = null;
                this.updateBlock();
                return;
            }
            object = this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.fromPos, null);
            if (object instanceof ISourceCap) {
                sourceHandler = (ISourceCap)object;
                if (this.transferSource(sourceHandler, this.getSourceStorage()) > 0) {
                    ParticleUtil.spawnFollowProjectile(this.level, this.fromPos, this.worldPosition, this.getColor());
                }
            } else {
                AbstractSourceMachine fromTile;
                object = this.level.getBlockEntity(this.fromPos);
                if (object instanceof AbstractSourceMachine && this.transferSource(fromTile = (AbstractSourceMachine)object, this) > 0) {
                    this.updateBlock();
                    ParticleUtil.spawnFollowProjectile(this.level, this.fromPos, this.worldPosition, this.getColor());
                }
            }
        }
        if (this.toPos != null && this.level.isLoaded(this.toPos)) {
            if (!(this.level.getBlockEntity(this.toPos) instanceof AbstractSourceMachine) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.toPos, null) == null) {
                this.toPos = null;
                this.updateBlock();
                return;
            }
            object = this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.toPos, null);
            if (object instanceof ISourceCap) {
                sourceHandler = (ISourceCap)object;
                if (this.transferSource(this.getSourceStorage(), sourceHandler) > 0) {
                    ParticleUtil.spawnFollowProjectile(this.level, this.worldPosition, this.toPos, this.getColor());
                }
            } else {
                AbstractSourceMachine toTile;
                object = this.level.getBlockEntity(this.toPos);
                if (object instanceof AbstractSourceMachine && this.transferSource(this, toTile = (AbstractSourceMachine)object) > 0) {
                    ParticleUtil.spawnFollowProjectile(this.level, this.worldPosition, this.toPos, this.getColor());
                }
            }
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.toPos = null;
        this.fromPos = null;
        if (NBTUtil.hasBlockPos(tag, this.TO)) {
            this.toPos = NBTUtil.getBlockPos(tag, this.TO);
        }
        if (NBTUtil.hasBlockPos(tag, this.FROM)) {
            this.fromPos = NBTUtil.getBlockPos(tag, this.FROM);
        }
        this.disabled = tag.getBoolean("disabled");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.toPos != null) {
            NBTUtil.storeBlockPos(tag, this.TO, this.toPos.immutable());
        } else {
            NBTUtil.removeBlockPos(tag, this.TO);
        }
        if (this.fromPos != null) {
            NBTUtil.storeBlockPos(tag, this.FROM, this.fromPos.immutable());
        } else {
            NBTUtil.removeBlockPos(tag, this.FROM);
        }
        tag.putBoolean("disabled", this.disabled);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.toPos == null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.one_to", (Object[])new Object[]{1}));
        }
        if (this.fromPos == null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_from"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.one_from", (Object[])new Object[]{1}));
        }
        if (this.disabled) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tooltip.turned_off"));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate));
        data.add(new AnimationController((GeoAnimatable)this, "float_controller", 0, this::floatPredicate));
    }

    private <P extends GeoAnimatable> PlayState idlePredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("floating"));
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState floatPredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

