/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.BlockProps;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TableBlock
extends TickableModBlock {
    public static final EnumProperty<ThreePartBlock> PART = BlockProps.TABLE_ENUM;
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.box((double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.box((double)16.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.box((double)16.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public TableBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 3.0f).noOcclusion().pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)ThreePartBlock.FOOT)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (!world.isClientSide) {
            BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
            world.setBlock(blockpos, (BlockState)state.setValue(PART, (Comparable)((Object)ThreePartBlock.HEAD)), 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        Direction direction = p_196258_1_.getHorizontalDirection();
        BlockPos blockpos = p_196258_1_.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        return p_196258_1_.getLevel().getBlockState(blockpos1).canBeReplaced(p_196258_1_) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public BlockState tearDown(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (direction == TableBlock.getNeighbourDirection((ThreePartBlock)((Object)state.getValue(PART)), (Direction)state.getValue((Property)FACING))) {
            return state2.is((Block)this) && state2.getValue(PART) != state.getValue(PART) ? state : this.tearDown(state, direction, state2, world, pos, pos2);
        }
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    public static Direction getNeighbourDirection(ThreePartBlock p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == ThreePartBlock.FOOT ? p_208070_1_ : p_208070_1_.getOpposite();
    }

    public static Direction getConnectedDirection(BlockState p_226862_0_) {
        Direction direction = (Direction)p_226862_0_.getValue((Property)FACING);
        return p_226862_0_.getValue(PART) == ThreePartBlock.HEAD ? direction.getOpposite() : direction;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = TableBlock.getConnectedDirection(state).getOpposite();
        return switch (direction) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

