/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class RainbowParticleColor
extends ParticleColor {
    public static final ResourceLocation ID = ArsNouveau.prefix("rainbow");
    public int tickOffset;

    public RainbowParticleColor(int r, int g, int b) {
        super(r, g, b);
        this.tickOffset = random.nextInt(1536);
    }

    public RainbowParticleColor(CompoundTag compoundTag) {
        super(compoundTag);
        this.tickOffset = compoundTag.getInt("tickOffset");
    }

    @Override
    public ParticleColor nextColor(int ticks) {
        return Color.rainbowColor(ticks).toParticle();
    }

    @Override
    public ParticleColor transition(int ticks) {
        Color color = Color.rainbowColor(ticks);
        RainbowParticleColor color1 = new RainbowParticleColor(color.getRed(), color.getGreen(), color.getBlue());
        color1.tickOffset = this.tickOffset;
        return color1;
    }

    @Override
    public float getRed() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getRedAsFloat();
    }

    @Override
    public int getRedInt() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getRed();
    }

    @Override
    public float getBlue() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getBlueAsFloat();
    }

    @Override
    public int getBlueInt() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getBlue();
    }

    @Override
    public int getGreenInt() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getGreen();
    }

    @Override
    public float getGreen() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getGreenAsFloat();
    }

    @Override
    public int getColor() {
        return RainbowParticleColor.fromInt(Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getRGB()).getColor();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof RainbowParticleColor)) return false;
        RainbowParticleColor color = (RainbowParticleColor)o;
        if (!this.getRegistryName().equals((Object)color.getRegistryName())) return false;
        return true;
    }
}

