/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.documentation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class DocDataLoader {
    public static final String DATA_FOLDER = "./config/ars_nouveau/";
    public static final Path DOC_DATA_PATH = Path.of("./config/ars_nouveau/doc_data.json", new String[0]);

    public static void writeBookmarks() {
        List<ResourceLocation> bookmarks = DocPlayerData.bookmarks;
        List<SpellSound> spellSounds = DocPlayerData.favoriteSounds;
        try {
            Files.createDirectories(Path.of(DATA_FOLDER, new String[0]), new FileAttribute[0]);
            JsonObject element = new JsonObject();
            element.addProperty("version", (Number)1);
            JsonArray bookmarksArray = new JsonArray();
            bookmarks.forEach(e -> bookmarksArray.add(e.toString()));
            element.add("bookmarks", (JsonElement)bookmarksArray);
            JsonArray soundsArray = new JsonArray();
            spellSounds.forEach(e -> soundsArray.add(e.getId().toString()));
            element.add("sounds", (JsonElement)soundsArray);
            JsonArray particlesArray = new JsonArray();
            DocPlayerData.favoriteParticles.forEach(e -> particlesArray.add(BuiltInRegistries.PARTICLE_TYPE.getKeyOrNull(e).toString()));
            element.add("particles", (JsonElement)particlesArray);
            if (!Files.exists(DOC_DATA_PATH, new LinkOption[0])) {
                Files.createFile(DOC_DATA_PATH, new FileAttribute[0]);
            }
            Files.writeString(DOC_DATA_PATH, (CharSequence)element.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void loadBookmarks() {
        ArrayList<ResourceLocation> bookmarks = new ArrayList<ResourceLocation>();
        ArrayList<SpellSound> sounds = new ArrayList<SpellSound>();
        ArrayList particles = new ArrayList();
        try {
            Files.createDirectories(Path.of(DATA_FOLDER, new String[0]), new FileAttribute[0]);
            String content = Files.readString(Path.of("./config/ars_nouveau/doc_data.json", new String[0]), StandardCharsets.UTF_8);
            JsonObject element = JsonParser.parseString((String)content).getAsJsonObject();
            if (element.has("bookmarks")) {
                element.getAsJsonArray("bookmarks").forEach(e -> bookmarks.add(ResourceLocation.tryParse((String)e.getAsString())));
                ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
                for (ResourceLocation loc : bookmarks) {
                    if (loc != null && DocumentationRegistry.getEntry(loc) != null) continue;
                    toRemove.add(loc);
                }
                bookmarks.removeAll(toRemove);
            }
            if (element.has("sounds")) {
                element.getAsJsonArray("sounds").forEach(e -> {
                    SpellSound spellSound = SpellSoundRegistry.get(ResourceLocation.tryParse((String)e.getAsString()));
                    if (spellSound != null) {
                        sounds.add(spellSound);
                    }
                });
            }
            if (element.has("particles")) {
                element.getAsJsonArray("particles").forEach(e -> {
                    ParticleType particle = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.tryParse((String)e.getAsString()));
                    if (particle != null) {
                        particles.add(particle);
                    }
                });
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        DocPlayerData.bookmarks = bookmarks;
        DocPlayerData.favoriteSounds = sounds;
        DocPlayerData.favoriteParticles = particles;
    }
}

