/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.item.inv.FilterSet;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class InvUtil {
    public static List<FilterableItemHandler> adjacentInventories(Level level, BlockPos pos) {
        ArrayList<FilterableItemHandler> inventories = new ArrayList<FilterableItemHandler>();
        for (Direction d : Direction.values()) {
            BlockPos relativePos = pos.relative(d);
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, relativePos, level.getBlockState(relativePos), null, (Object)d.getOpposite());
            if (handler == null) continue;
            inventories.add(new FilterableItemHandler(handler, FilterSet.forPosition(level, relativePos)));
        }
        return inventories;
    }

    @Deprecated(forRemoval=true)
    public static List<Function<ItemStack, ItemScroll.SortPref>> filtersOnTile(@Nullable BlockEntity thisTile) {
        if (thisTile == null) {
            return new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
        }
        FilterSet filterSet = FilterSet.forPosition(thisTile.getLevel(), thisTile.getBlockPos());
        if (filterSet instanceof FilterSet.ListSet) {
            FilterSet.ListSet listSet = (FilterSet.ListSet)filterSet;
            return listSet.filters;
        }
        return new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
    }

    public static List<FilterableItemHandler> fromPlayer(Player player) {
        ArrayList<FilterableItemHandler> list = new ArrayList<FilterableItemHandler>();
        list.add(new FilterableItemHandler((IItemHandler)new PlayerMainInvWrapper(player.inventory), new ArrayList<Function<ItemStack, ItemScroll.SortPref>>()));
        return list;
    }
}

