/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.source;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import com.hollingsworth.arsnouveau.common.items.data.BlockFillContents;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSourceMachine
extends ModdedTile
implements ISourceTile,
IWololoable {
    private ParticleColor color = ParticleColor.defaultParticleColor();
    public static String SOURCE_TAG = "source";
    public static String COLOR_TAG = "color";
    @Nullable
    public SourceStorage sourceStorage;

    public AbstractSourceMachine(BlockEntityType<?> manaTile, BlockPos pos, BlockState state) {
        super(manaTile, pos, state);
    }

    @NotNull
    public SourceStorage getSourceStorage() {
        if (this.sourceStorage == null) {
            this.sourceStorage = this.createDefaultStorage();
            if (this.level != null) {
                this.level.invalidateCapabilities(this.worldPosition);
            }
        }
        return this.sourceStorage;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.sourceStorage = this.createDefaultStorage();
        if (tag.contains(SOURCE_TAG)) {
            this.sourceStorage.setSource(tag.getInt(SOURCE_TAG));
        }
        this.color = ParticleColor.fromInt(tag.getInt(COLOR_TAG));
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt(SOURCE_TAG, this.getSource());
        tag.putInt(COLOR_TAG, this.getColor().getColor());
    }

    @NotNull
    protected SourceStorage createDefaultStorage() {
        return new SourceStorage(10000, 1000, 1000, 0){

            @Override
            public void onContentsChanged() {
                AbstractSourceMachine.this.updateBlock();
            }
        };
    }

    @Override
    public int setSource(int source) {
        this.getSourceStorage().setSource(Math.clamp((long)source, 0, this.getMaxSource()));
        this.updateBlock();
        return this.getSourceStorage().getSource();
    }

    @Override
    public boolean updateBlock() {
        if (this.level != null) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public int addSource(int source, boolean simulate) {
        return this.getSourceStorage().receiveSource(source, simulate);
    }

    @Override
    public int addSource(int source) {
        return this.setSource(this.getSource() + source);
    }

    @Override
    public int getSource() {
        return this.getSourceStorage().getSource();
    }

    @Override
    public int getTransferRate() {
        return this.getSourceStorage().getMaxExtract();
    }

    @Override
    public int removeSource(int source, boolean simulate) {
        return this.getSourceStorage().extractSource(source, simulate);
    }

    @Override
    public int removeSource(int source) {
        if (source == 0) {
            return this.getSource();
        }
        this.setSource(this.getSource() - source);
        return this.getSource();
    }

    @Override
    public int getMaxSource() {
        return this.getSourceStorage().getSourceCapacity();
    }

    @Override
    public boolean canAcceptSource() {
        return this.getSource() < this.getMaxSource();
    }

    @Override
    public boolean canProvideSource() {
        return this.getSource() > 0;
    }

    public boolean canAcceptSource(int source) {
        return this.getSourceStorage().canAcceptSource(source);
    }

    public int transferSource(ISourceTile from, ISourceTile to) {
        int transferRate = this.getTransferRate(from, to);
        from.removeSource(transferRate);
        to.addSource(transferRate);
        return transferRate;
    }

    public int transferSource(ISourceCap from, ISourceCap to) {
        return this.transferSource(from, to, from.getMaxExtract());
    }

    public int transferSource(ISourceCap from, ISourceCap to, int amount) {
        int transfer = to.receiveSource(from.extractSource(amount, true), true);
        if (transfer == 0) {
            return 0;
        }
        from.extractSource(transfer, false);
        to.receiveSource(transfer, false);
        return transfer;
    }

    @Deprecated(forRemoval=true)
    public int getTransferRate(ISourceTile from, ISourceTile to) {
        return this.getTransferRate(from, to, from.getTransferRate());
    }

    @Deprecated(forRemoval=true)
    public int getTransferRate(ISourceTile from, ISourceTile to, int fromTransferRate) {
        return Math.min(Math.min(fromTransferRate, from.getSource()), to.getMaxSource() - to.getSource());
    }

    @Deprecated(forRemoval=true)
    public int transferSource(ISourceTile from, ISourceTile to, int fromTransferRate) {
        int transferRate = this.getTransferRate(from, to, fromTransferRate);
        if (transferRate == 0) {
            return 0;
        }
        from.removeSource(transferRate);
        to.addSource(transferRate);
        return transferRate;
    }

    @Override
    public ParticleColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(ParticleColor color) {
        this.color = color;
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        BlockFillContents fill = (BlockFillContents)pComponentInput.getOrDefault(DataComponentRegistry.BLOCK_FILL_CONTENTS, (Object)new BlockFillContents(0));
        this.getSourceStorage().setSource(fill.amount());
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        int source = this.getSourceStorage().getSource();
        if (source != 0) {
            pComponents.set(DataComponentRegistry.BLOCK_FILL_CONTENTS, (Object)new BlockFillContents(source));
        }
    }
}

