/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.particle.configurations.ListParticleWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import com.hollingsworth.arsnouveau.client.gui.HorizontalSlider;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SoundProperty
extends BaseProperty<SoundProperty> {
    public ConfiguredSpellSound sound;
    public static MapCodec<SoundProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ConfiguredSpellSound.CODEC.fieldOf("sound").forGetter(i -> i.sound)).apply((Applicative)instance, SoundProperty::new));
    public static StreamCodec<RegistryFriendlyByteBuf, SoundProperty> STREAM_CODEC = StreamCodec.composite(ConfiguredSpellSound.STREAM, i -> i.sound, SoundProperty::new);

    public SoundProperty(ConfiguredSpellSound sound) {
        this.sound = sound;
    }

    public SoundProperty() {
        this(ConfiguredSpellSound.DEFAULT);
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        ArrayList<DocEntryButton> buttons = new ArrayList<DocEntryButton>();
        ArrayList<SpellSound> spellSounds = new ArrayList<SpellSound>(SpellSoundRegistry.getSpellSounds());
        spellSounds.sort(Comparator.comparingInt(o -> DocPlayerData.favoriteSounds.contains(o) ? -1 : 1).thenComparingInt(SpellSound::sortNum).thenComparing(o -> o.getSoundName().getString().toLowerCase(Locale.ROOT)));
        for (SpellSound spellSound : spellSounds) {
            DocEntryButton button = new DocEntryButton(0, 0, ItemStack.EMPTY, spellSound.getSoundName(), b -> {
                this.sound = new ConfiguredSpellSound(spellSound, this.sound.getVolume(), this.sound.getPitch());
            }).setFavoritable(() -> DocPlayerData.favoriteSounds.contains(spellSound), b -> {
                if (DocPlayerData.favoriteSounds.contains(spellSound)) {
                    DocPlayerData.favoriteSounds.remove(spellSound);
                } else {
                    DocPlayerData.favoriteSounds.add(spellSound);
                }
            });
            button.onClickFunction = (xPos, yPos, buttonNum) -> {
                if (button.active && button.visible && buttonNum == 1) {
                    this.playTestSound(new ConfiguredSpellSound(spellSound, this.sound.getVolume(), this.sound.getPitch()));
                    return true;
                }
                return false;
            };
            button.withTooltip((Component)Component.translatable((String)"ars_nouveau.right_click_sound"));
            buttons.add(button);
        }
        return new ListParticleWidgetProvider(x, y, width, height, buttons, 4, () -> this.providerData){
            HorizontalSlider volumeSlider;
            HorizontalSlider pitchSlider;

            @Override
            public void addWidgets(List<AbstractWidget> widgets) {
                super.addWidgets(widgets);
                int yOffset = 103;
                int xSliderOffset = this.x + 4;
                this.volumeSlider = this.buildSlider(xSliderOffset, this.y + yOffset, 5.0, 200.0, 5.0, 1, (Component)Component.translatable((String)"ars_nouveau.xzmaxspeed_slider"), (Component)Component.empty(), 0.0, value -> {
                    SoundProperty.this.sound = new ConfiguredSpellSound(SoundProperty.this.sound.getSound(), (float)(this.volumeSlider.getValue() / 100.0), SoundProperty.this.sound.getPitch());
                });
                this.pitchSlider = this.buildSlider(xSliderOffset, this.y + (yOffset += 25), 5.0, 200.0, 5.0, 1, (Component)Component.translatable((String)"ars_nouveau.xzmaxspeed_slider"), (Component)Component.empty(), 0.0, value -> {
                    SoundProperty.this.sound = new ConfiguredSpellSound(SoundProperty.this.sound.getSound(), SoundProperty.this.sound.getVolume(), (float)this.pitchSlider.getValue() / 100.0f);
                });
                GuiImageButton testButton = new GuiImageButton(xSliderOffset, this.y + (yOffset += 10), 37, 12, ArsNouveau.prefix("textures/gui/sound_test_icon.png"), b -> SoundProperty.this.playTestSound(SoundProperty.this.sound));
                testButton.soundDisabled = true;
                this.volumeSlider.setValue(SoundProperty.this.sound.getVolume() * 100.0f);
                this.pitchSlider.setValue(SoundProperty.this.sound.getPitch() * 100.0f);
                widgets.add((AbstractWidget)this.volumeSlider);
                widgets.add((AbstractWidget)this.pitchSlider);
                widgets.add((AbstractWidget)testButton);
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(SoundProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
                int yOffset = 93;
                int sliderSpacing = 25;
                DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.sounds.volume", (Object[])new Object[]{this.volumeSlider.getValueString()}), graphics, this.x, this.y + yOffset, this.width, mouseX, mouseY, partialTicks);
                DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.sounds.pitch", (Object[])new Object[]{this.pitchSlider.getValueString()}), graphics, this.x, this.y + (yOffset += sliderSpacing), this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.blit(graphics, DocAssets.SOUND_ICON, x, y);
            }

            @Override
            public Component getButtonTitle() {
                return Component.literal((String)(SoundProperty.this.getName().getString() + ": " + SoundProperty.this.sound.getSound().getSoundName().getString()));
            }

            public HorizontalSlider buildSlider(int x, int y, double min, double max, double stepSize, int precision, Component prefix, Component suffix, double currentVal, Consumer<Double> onValueChange) {
                return new HorizontalSlider(x, y, DocAssets.SLIDER_BAR_FILLED, DocAssets.SLIDER, prefix, suffix, min, max, currentVal, stepSize, precision, false, onValueChange);
            }
        };
    }

    private void playTestSound(ConfiguredSpellSound sound) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Vec3 pos = localPlayer.position().add(0.0, 2.0, 0.0);
        localPlayer.level.playLocalSound(pos.x(), pos.y(), pos.z(), (SoundEvent)sound.getSound().getSoundEvent().value(), SoundSource.PLAYERS, sound.getVolume(), sound.getPitch(), false);
    }

    @Override
    public IPropertyType<SoundProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.SOUND_PROPERTY.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundProperty that = (SoundProperty)o;
        return Objects.equals(this.sound, that.sound);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sound);
    }
}

