/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.common.light.DynamLightUtil;
import com.hollingsworth.arsnouveau.common.light.LambDynamicLight;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import dev.lambdaurora.lambdynlights.api.DynamicLightsContext;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class FadeLightTimedEvent
implements ITimedEvent,
LambDynamicLight,
DynamicLightBehavior {
    protected int luminance = 0;
    private int lastLuminance = 0;
    private LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();
    private final DynamicLightBehavior.BoundingBox box;
    public final Vec3 targetPos;
    public int ticksLeft;
    int starterTicks;
    int startLuminance;
    Level level;

    public FadeLightTimedEvent(Level level, Vec3 pos, int duration, int startLuminance) {
        this.box = new DynamicLightBehavior.BoundingBox(Mth.floor((double)pos.x), Mth.floor((double)pos.y), Mth.floor((double)pos.z), Mth.ceil((double)pos.x), Mth.ceil((double)pos.y), Mth.ceil((double)pos.z));
        this.targetPos = pos;
        this.ticksLeft = duration;
        this.starterTicks = duration;
        this.startLuminance = startLuminance;
        this.level = level;
    }

    @Override
    public void tick(boolean serverSide) {
        if (serverSide) {
            return;
        }
        DynamicLightsContext context = LightManager.dynamicLightsContext;
        if (context == null) {
            if (!LightManager.shouldUpdateDynamicLight()) {
                this.luminance = 0;
            } else if (LightManager.shouldUpdateDynamicLight()) {
                if (this.isExpired()) {
                    this.ars_nouveau$setDynamicLightEnabled(false);
                } else {
                    this.ars_nouveau$dynamicLightTick();
                    LightManager.updateTracking(this);
                }
            }
        } else {
            this.ars_nouveau$dynamicLightTick();
        }
        --this.ticksLeft;
        if (this.ticksLeft <= 0 && context == null) {
            this.ars_nouveau$setDynamicLightEnabled(false);
        }
    }

    @Override
    public boolean isExpired() {
        return this.ticksLeft <= 0;
    }

    @Override
    public double ars_nouveau$getDynamicLightX() {
        return this.targetPos.x;
    }

    @Override
    public double ars_nouveau$getDynamicLightY() {
        return this.targetPos.y;
    }

    @Override
    public double ars_nouveau$getDynamicLightZ() {
        return this.targetPos.z;
    }

    @Override
    public Level ars_nouveau$getDynamicLightWorld() {
        return this.level;
    }

    @Override
    public void ars_nouveau$resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public int ars_nouveau$getLuminance() {
        return this.luminance;
    }

    @Override
    public void ars_nouveau$dynamicLightTick() {
        this.luminance = this.starterTicks == 0 ? 0 : (int)((double)this.startLuminance * ((double)this.ticksLeft / (double)this.starterTicks));
    }

    @Override
    public boolean ars_nouveau$shouldUpdateDynamicLight() {
        return LightManager.shouldUpdateDynamicLight();
    }

    @Override
    public boolean ars_nouveau$updateDynamicLight(LevelRenderer renderer) {
        int luminance = this.ars_nouveau$getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                ChunkPos entityChunkPos = new ChunkPos(BlockPos.containing((Position)this.targetPos));
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.x, DynamLightUtil.getSectionCoord(this.targetPos.y), entityChunkPos.z);
                LightManager.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                LightManager.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                BlockPos blockPos = BlockPos.containing((Position)this.targetPos);
                Direction directionX = (blockPos.getX() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (Mth.floor((float)blockPos.getY()) & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (blockPos.getZ() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.move(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.move(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.move(directionX.getOpposite());
                    } else {
                        chunkPos.move(directionZ.getOpposite());
                        chunkPos.move(directionY);
                    }
                    LightManager.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                    LightManager.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                }
            }
            this.ars_nouveau$scheduleTrackedChunksRebuild(renderer);
            this.lambdynlights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void ars_nouveau$scheduleTrackedChunksRebuild(LevelRenderer renderer) {
        if (Minecraft.getInstance().level == this.level) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LightManager.scheduleChunkRebuild(renderer, pos);
            }
        }
    }

    public @Range(from=0L, to=15L) double lightAtPos(BlockPos pos, double falloffRatio) {
        double dx = (double)pos.getX() - this.targetPos.x + 0.5;
        double dy = (double)pos.getY() - this.targetPos.y + 0.5;
        double dz = (double)pos.getZ() - this.targetPos.z + 0.5;
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        return LightManager.maxDynamicLightLevel(distanceSquared, 0.0, this.luminance);
    }

    @NotNull
    public DynamicLightBehavior.BoundingBox getBoundingBox() {
        return this.box;
    }

    public boolean hasChanged() {
        if (this.lastLuminance != this.luminance) {
            this.lastLuminance = this.luminance;
            return true;
        }
        return false;
    }

    public boolean isRemoved() {
        return this.isExpired();
    }
}

