/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.DocItemTooltipHandler;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.IndexScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.gui.NuggetMultilLineLabel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.StringUtils;

public class DocClientUtils {
    public static final int ROWS_FOR_TITLE_PAGE = 14;
    public static final int ROWS_FOR_NORMAL_PAGE = 17;
    public static final int PARAGRAPH_WIDTH = 118;

    public static void openBook() {
        if (DocPlayerData.previousScreen != null) {
            Minecraft.getInstance().setScreen((Screen)DocPlayerData.previousScreen);
            return;
        }
        IndexScreen.open();
    }

    public static void openToEntry(ResourceLocation resourceLocation, int pageIndex) {
        block5: {
            PageHolderScreen pageHolderScreen;
            block7: {
                block6: {
                    DocEntry entry;
                    block4: {
                        entry = DocumentationRegistry.getEntry(resourceLocation);
                        if (entry == null) {
                            IndexScreen.open();
                            return;
                        }
                        Screen screen = Minecraft.getInstance().screen;
                        if (!(screen instanceof BaseDocScreen)) break block4;
                        BaseDocScreen baseDocScreen = (BaseDocScreen)screen;
                        baseDocScreen.transition(new PageHolderScreen(entry));
                        break block5;
                    }
                    pageHolderScreen = new PageHolderScreen(entry);
                    pageHolderScreen.arrowIndex = pageIndex < entry.pages().size() ? pageIndex : 0;
                    BaseDocScreen baseDocScreen = DocPlayerData.previousScreen;
                    if (!(baseDocScreen instanceof PageHolderScreen)) break block6;
                    PageHolderScreen pageHolderScreen1 = (PageHolderScreen)baseDocScreen;
                    if (pageHolderScreen1.entry == entry) break block7;
                }
                pageHolderScreen.previousScreen = DocPlayerData.previousScreen;
            }
            Minecraft.getInstance().setScreen((Screen)pageHolderScreen);
        }
    }

    public static void drawStringScaled(GuiGraphics graphics, Component component, int x, int y, int color, float scale, boolean shadow) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(x + 3), (float)y, 0.0f);
        graphics.drawString(Minecraft.getInstance().font, (Component)component.copy().withStyle(component.getStyle().withFont(Minecraft.UNIFORM_FONT)), 0, 0, color, shadow);
        poseStack.popPose();
    }

    public static void drawHeader(NuggetMultilLineLabel title, GuiGraphics graphics, int x, int y) {
        title.renderCenteredNoShadow(graphics, x, y + (title.getLineCount() > 1 ? 3 : 7), 8, 0);
    }

    public static void blit(GuiGraphics graphics, DocAssets.BlitInfo info, int x, int y) {
        graphics.blit(info.location(), x, y, (float)info.u(), (float)info.v(), info.width(), info.height(), info.width(), info.height());
    }

    public static ItemStack renderIngredientAtAngle(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float angle, Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int radius = 41;
        double xPos = (double)x + DocClientUtils.nextXAngle(angle -= 90.0f, radius);
        double yPos = (double)y + DocClientUtils.nextYAngle(angle, radius);
        PoseStack ms = graphics.pose();
        ms.pushPose();
        ms.translate(xPos - (double)((int)xPos), yPos - (double)((int)yPos), 0.0);
        ItemStack hovered = DocClientUtils.renderIngredient(graphics, (int)xPos, (int)yPos, mouseX, mouseY, ingredient);
        ms.popPose();
        return hovered;
    }

    public static double nextXAngle(double angle, int radius) {
        return Math.cos(angle * Math.PI / 180.0) * (double)radius + 32.0;
    }

    public static double nextYAngle(double angle, int radius) {
        return Math.sin(angle * Math.PI / 180.0) * (double)radius + 32.0;
    }

    public static ItemStack renderIngredient(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        ItemStack[] stacks = ingr.getItems();
        if (stacks.length > 0) {
            return DocClientUtils.renderItemStack(graphics, x, y, mouseX, mouseY, stacks[ClientInfo.ticksInGame / 20 % stacks.length]);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack renderItemStack(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Font font = Minecraft.getInstance().font;
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(font, stack, x, y);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            DocItemTooltipHandler.onTooltip(graphics, stack, mouseX, mouseY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static void drawHeader(@Nullable Component title, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        DocClientUtils.blit(guiGraphics, DocAssets.UNDERLINE, x, y + 9);
        if (title != null) {
            GuiHelpers.drawCenteredStringNoShadow((Font)Minecraft.getInstance().font, (GuiGraphics)guiGraphics, (Component)title, (int)(x + width / 2), (int)y, (int)0);
        }
    }

    public static void drawHeaderNoUnderline(@Nullable Component title, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        if (title != null) {
            GuiHelpers.drawCenteredStringNoShadow((Font)Minecraft.getInstance().font, (GuiGraphics)guiGraphics, (Component)title, (int)(x + width / 2), (int)y, (int)0);
        }
    }

    public static void drawParagraph(Component text, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(x + 1), (float)y, 0.0f);
        NuggetMultilLineLabel label = NuggetMultilLineLabel.create((Font)Minecraft.getInstance().font, (Component)text.copy().withStyle(Style.EMPTY.withFont(Minecraft.UNIFORM_FONT)), (int)width);
        int lineHeight = 9;
        label.renderLeftAlignedNoShadow(guiGraphics, 0, 0, lineHeight, 0);
        poseStack.popPose();
    }

    public static void drawParagraph(NuggetMultilLineLabel label, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        int lineHeight = 9;
        label.renderLeftAlignedNoShadow(guiGraphics, x + 1, y, lineHeight, 0);
    }

    public static List<NuggetMultilLineLabel> splitToFitFullPage(Component text) {
        return DocClientUtils.splitToFitPageWithOffset(text, 17, 17);
    }

    public static List<NuggetMultilLineLabel> splitToFitTitlePage(Component text) {
        return DocClientUtils.splitToFitPageWithOffset(text, 14, 17);
    }

    public static List<NuggetMultilLineLabel> splitToFitPageWithOffset(Component text, int firstMaxRows, int secondMaxRows) {
        Font font = Minecraft.getInstance().font;
        ArrayList list = Lists.newArrayList();
        String content = text.getString();
        font.getSplitter().splitLines(content, 118, Style.EMPTY.withFont(Minecraft.UNIFORM_FONT), true, (style, currentPos, width) -> {
            String s2 = content.substring(currentPos, width);
            boolean addLine = false;
            if (StringUtils.endsWith((CharSequence)s2, (CharSequence)"\n")) {
                s2 = StringUtils.stripEnd((String)s2, (String)"\n").trim();
                addLine = true;
            }
            if (!s2.isEmpty()) {
                list.add(FormattedText.of((String)s2, (Style)style));
                if (addLine) {
                    list.add(FormattedText.of((String)" ", (Style)style));
                }
            }
        });
        ArrayList<NuggetMultilLineLabel> labels = new ArrayList<NuggetMultilLineLabel>();
        List<FormattedText> firstList = list.subList(0, Math.min(firstMaxRows, list.size()));
        NuggetMultilLineLabel firstLabel = NuggetMultilLineLabel.create((Font)font, (int)118, (Component[])DocClientUtils.formattedToComponent(firstList).toArray(new Component[0]));
        labels.add(firstLabel);
        for (int i = firstMaxRows; i < list.size(); i += secondMaxRows) {
            int end = Math.min(i + secondMaxRows, list.size());
            List<Component> sublist = DocClientUtils.formattedToComponent(list.subList(i, end));
            while (!sublist.isEmpty() && sublist.getFirst().getString().trim().isEmpty()) {
                sublist.removeFirst();
                end = Math.min(++i + secondMaxRows, list.size());
                sublist = DocClientUtils.formattedToComponent(list.subList(i, end));
            }
            NuggetMultilLineLabel label = NuggetMultilLineLabel.create((Font)font, (int)118, (Component[])sublist.toArray(new Component[0]));
            labels.add(label);
        }
        return labels;
    }

    private static List<Component> formattedToComponent(List<FormattedText> list) {
        ArrayList<Component> components = new ArrayList<Component>();
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            FormattedText formatted = list.get(i);
            MutableComponent component = Component.literal((String)formatted.getString()).withStyle(Style.EMPTY.withFont(Minecraft.UNIFORM_FONT));
            components.add((Component)component);
        }
        return components;
    }
}

