/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class QuartzSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    public QuartzSpikeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private boolean isValidGround(BlockState state) {
        return state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT) || state.is(Blocks.STONE) || state.is(Blocks.SAND) || state.is(Blocks.GRAVEL);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockPos blockpos = origin;
        while (blockpos.getY() > level.getMinBuildHeight() + 3) {
            BlockState stateBelow = level.getBlockState(blockpos.below());
            if (!level.isEmptyBlock(blockpos.below()) && this.isValidGround(stateBelow)) break;
            blockpos = blockpos.below();
        }
        if (blockpos.getY() <= level.getMinBuildHeight() + 3) {
            return false;
        }
        blockpos = blockpos.below();
        int height = random.nextInt(6) + 4;
        int baseRadius = random.nextInt(2) + 1;
        int quartzStart = height * 2 / 3;
        for (int y = 0; y < height; ++y) {
            int radius = baseRadius - y / (height / baseRadius);
            if (radius < 0 || y >= height - 2) {
                radius = 0;
            }
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dz * dz > radius * radius) continue;
                    BlockPos pos = blockpos.offset(dx, y, dz);
                    if (y >= quartzStart) {
                        level.setBlock(pos, Blocks.QUARTZ_BLOCK.defaultBlockState(), 2);
                        continue;
                    }
                    BlockState whiteRock = random.nextBoolean() ? Blocks.CALCITE.defaultBlockState() : Blocks.DIORITE.defaultBlockState();
                    level.setBlock(pos, whiteRock, 2);
                }
            }
        }
        return true;
    }
}

