/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.registry.ModEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class FlashLightning
extends LightningBolt {
    public FlashLightning(EntityType<? extends LightningBolt> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FlashLightning(Level pLevel) {
        super((EntityType)ModEntities.FLASH_LIGHTNING.get(), pLevel);
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.FLASH_LIGHTNING.get();
    }

    public void tick() {
        this.baseTick();
        if (this.life == 2) {
            if (this.level.isClientSide()) {
                this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 0.6f, 0.8f + this.random.nextFloat() * 0.2f, false);
                this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 0.5f, 0.5f + this.random.nextFloat() * 0.2f, false);
            } else {
                this.powerLightningRod();
                FlashLightning.clearCopperOnLightningStrike((Level)this.level, (BlockPos)this.getStrikePosition());
                this.gameEvent((Holder)GameEvent.LIGHTNING_STRIKE);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                this.discard();
            } else if (this.life < -this.random.nextInt(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
            }
        }
        if (this.life >= 0) {
            Level level = this.level;
            if (!(level instanceof ServerLevel)) {
                this.level.setSkyFlashTime(2);
            } else {
                ServerLevel serverLevel = (ServerLevel)level;
                List list1 = this.level.getEntities((Entity)this, new AABB(this.getX() - 3.0, this.getY() - 3.0, this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 6.0 + 3.0, this.getZ() + 3.0), Entity::isAlive);
                for (Entity entity : list1) {
                    if (EventHooks.onEntityStruckByLightning((Entity)entity, (LightningBolt)this)) continue;
                    entity.thunderHit(serverLevel, (LightningBolt)this);
                }
                this.hitEntities.addAll(list1);
            }
        }
    }
}

