/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.mages;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.ai.MageProjCastingGoal;
import alexthw.ars_elemental.common.entity.ai.SelfCastGoal;
import alexthw.ars_elemental.common.items.armor.ElementalArmor;
import com.alexthw.sauce.api.item.ISchoolFocus;
import com.alexthw.sauce.api.item.ISchoolProvider;
import com.alexthw.sauce.util.ParticleUtil;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMageBase
extends Monster
implements RangedAttackMob,
ISchoolProvider,
IAnimationListener {
    public final List<Spell> pSpells = new ArrayList<Spell>();
    public final List<Spell> sSpells = new ArrayList<Spell>();
    public SpellSchool school;
    public String type = "medium";
    public int castCooldown = 0;
    public int animationTimer = 0;
    public int currentAnim = -1;

    public EntityMageBase(EntityType<? extends Monster> type, Level level, @Nullable SpellSchool school) {
        this(type, level);
        this.school = school;
    }

    protected EntityMageBase(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        if (this.pSpells.isEmpty()) {
            this.pSpells.add(new Spell(new AbstractSpellPart[]{MethodProjectile.INSTANCE, EffectHarm.INSTANCE, AugmentAmplify.INSTANCE}));
        }
        this.sSpells.add(new Spell(new AbstractSpellPart[]{MethodSelf.INSTANCE, EffectHeal.INSTANCE, AugmentAmplify.INSTANCE}));
    }

    public void tick() {
        super.tick();
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.currentAnim > 0 && this.animationTimer == 0) {
            this.currentAnim = -1;
        }
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityMageBase.class, true, e -> {
            if (!(e instanceof EntityMageBase)) return false;
            EntityMageBase mage = (EntityMageBase)((Object)e);
            if (this.school == mage.school) return false;
            return true;
        }));
        if (((Boolean)ConfigHandler.Common.MAGES_AGGRO.get()).booleanValue()) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, e -> {
                Player player;
                return e instanceof Player && !ISchoolFocus.getFociSchools((LivingEntity)(player = (Player)e)).contains(this.school);
            }));
        }
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, e -> !(e instanceof EntityMageBase)));
        this.goalSelector.addGoal(3, new MageProjCastingGoal<EntityMageBase>(this, 1.0, 30, 64.0f, () -> this.castCooldown <= 0, 2, 10));
        this.goalSelector.addGoal(2, new SelfCastGoal<EntityMageBase>(this, 10, 0, () -> this.castCooldown <= 10 && this.getHealth() <= this.getMaxHealth() / 3.0f, 1, 10));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
        super.registerGoals();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.populateDefaultEquipmentSlots(pLevel.getRandom(), pDifficulty);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public static ItemStack getArmorForSlot(EquipmentSlot slot, SpellSchool school, String type) {
        Item item;
        switch (slot) {
            case HEAD: {
                Item item2 = ElementalArmor.getArmorSetFromElement(school, type).getHat();
                break;
            }
            case CHEST: {
                Item item2 = ElementalArmor.getArmorSetFromElement(school, type).getChest();
                break;
            }
            case LEGS: {
                Item item2 = ElementalArmor.getArmorSetFromElement(school, type).getLegs();
                break;
            }
            case FEET: {
                Item item2 = ElementalArmor.getArmorSetFromElement(school, type).getBoots();
                break;
            }
            default: {
                Item item2 = item = null;
            }
        }
        if (item == null) {
            return ItemStack.EMPTY;
        }
        return item.getDefaultInstance();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void performRangedAttack(@NotNull LivingEntity pTarget, float pDistanceFactor) {
        Spell spell = this.pSpells.get(this.random.nextInt(this.pSpells.size()));
        ParticleColor color = ParticleUtil.schoolToColor((String)this.school.getId());
        MageResolver resolver = new MageResolver(new SpellContext(this.level(), spell, (LivingEntity)this, (IWrappedCaster)new LivingCaster((LivingEntity)this)).withColors(color), this.school);
        resolver.onCast(ItemStack.EMPTY, this.level());
        this.castCooldown = 40;
    }

    public void startAnimation(int arg) {
        this.currentAnim = arg;
        this.animationTimer = arg * 20;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("cast", this.castCooldown);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.castCooldown = tag.getInt("cast");
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    public boolean isAlliedTo(@NotNull Entity pEntity) {
        LivingEntity living;
        return super.isAlliedTo(pEntity) || pEntity instanceof LivingEntity && ISchoolFocus.getFociSchools((LivingEntity)(living = (LivingEntity)pEntity)).contains(this.school);
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public int getBaseExperienceReward() {
        return 15;
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource randomSource, @NotNull DifficultyInstance pDifficulty) {
        super.populateDefaultEquipmentSlots(randomSource, pDifficulty);
        if (this.school != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.setItemSlot(slot, EntityMageBase.getArmorForSlot(slot, this.school, this.type));
            }
        } else {
            this.setItemSlot(EquipmentSlot.HEAD, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_HOOD.get()).getDefaultInstance());
            this.setItemSlot(EquipmentSlot.CHEST, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_ROBES.get()).getDefaultInstance());
            this.setItemSlot(EquipmentSlot.LEGS, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_LEGGINGS.get()).getDefaultInstance());
            this.setItemSlot(EquipmentSlot.FEET, ((AnimatedMagicArmor)ItemsRegistry.BATTLEMAGE_BOOTS.get()).getDefaultInstance());
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, ((SpellBook)ItemsRegistry.APPRENTICE_SPELLBOOK.get()).getDefaultInstance());
    }

    public SpellSchool getSchool() {
        return this.school;
    }

    public static class MageResolver
    extends EntitySpellResolver {
        private final SpellSchool school;

        public SpellSchool getSchool() {
            return this.school;
        }

        public MageResolver(SpellContext context, SpellSchool school) {
            super(context);
            this.school = school;
        }

        public boolean hasFocus(ItemStack stack) {
            return this.hasFocus(stack.getItem());
        }

        public boolean hasFocus(Item item) {
            if (item instanceof ISchoolFocus) {
                ISchoolFocus focus = (ISchoolFocus)item;
                return this.school == focus.getSchool();
            }
            if (item == ItemsRegistry.SHAPERS_FOCUS.get()) {
                return true;
            }
            return super.hasFocus(item);
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new MageResolver(context, this.school);
        }
    }
}

