/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.familiars;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FirenandoFamiliar
extends FamiliarEntity
implements ISpellCastListener {
    public static List<AbstractSpellPart> projectileGlyphs = new ArrayList<AbstractSpellPart>();

    public FirenandoFamiliar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public FirenandoFamiliar(Level world) {
        super((EntityType)ModEntities.FIRENANDO_FAMILIAR.get(), world);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        super.registerControllers(data);
        data.add(new AnimationController((GeoAnimatable)this, "idle_controller", 0, this::idlePredicate));
    }

    public void onModifier(SpellModifierEvent event) {
        if (this.isAlive() && this.getOwner() != null && this.getOwner().equals((Object)event.caster) && SpellSchools.ELEMENTAL_FIRE.isPartOfSchool(event.spellPart)) {
            event.builder.addDamageModifier(2.0);
        }
    }

    public void onCostCalc(SpellCostCalcEvent event) {
        if (this.isAlive() && this.getOwner() != null && this.getOwner().equals((Object)event.context.getUnwrappedCaster()) && projectileGlyphs.contains(event.context.getSpell().unsafeList().getFirst())) {
            event.currentCost = (int)((double)event.currentCost - (double)event.context.getSpell().getCost() * 0.5);
        }
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (!player.level().isClientSide && player.equals((Object)this.getOwner())) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.getItem() == Items.MAGMA_CREAM) {
                stack.shrink(1);
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1200));
                return InteractionResult.SUCCESS;
            }
            if (stack.getItem() == Blocks.MAGMA_BLOCK.asItem() && !this.getColor().equals(FirenandoEntity.Variants.MAGMA.toString())) {
                this.setColor(FirenandoEntity.Variants.MAGMA.toString());
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (stack.getItem() == Blocks.SOUL_SAND.asItem() && !this.getColor().equals(FirenandoEntity.Variants.SOUL.toString())) {
                this.setColor(FirenandoEntity.Variants.SOUL.toString());
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public PlayState walkPredicate(AnimationState event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    public PlayState idlePredicate(AnimationState<FirenandoFamiliar> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle.body"));
    }

    @NotNull
    public ResourceLocation getTexture() {
        return ArsElemental.prefix("textures/entity/firenando_" + (this.getColor().isEmpty() ? FirenandoEntity.Variants.MAGMA.toString() : this.getColor()) + ".png");
    }
}

