/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.upstream;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.blocks.upstream.UpstreamTile;
import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WaterUpstreamTile
extends UpstreamTile {
    public WaterUpstreamTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.WATER_UPSTREAM_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected boolean isValidTarget(LivingEntity entity) {
        return !entity.isSpectator() && entity.isInWater() && !entity.isCrouching();
    }

    @Override
    protected int getSourceCost(int power) {
        return (Integer)ConfigHandler.Common.WATER_ELEVATOR_COST.get() * power;
    }

    @Override
    protected void applyEffects(ServerLevel level, LivingEntity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        entity.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 100));
        double d0 = Math.max(0.4, vec3.y + 0.1);
        entity.setDeltaMovement(vec3.x, d0, vec3.z);
        entity.resetFallDistance();
        for (int i = 0; i < 3; ++i) {
            this.elevatorParticles((Entity)entity, level);
        }
        entity.hurtMarked = true;
    }

    @Override
    public void elevatorParticles(Entity e, ServerLevel level) {
        double d0 = e.getX();
        double d1 = e.getY();
        double d2 = e.getZ();
        level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, d0 + ParticleUtil.inRange((double)-0.5, (double)0.5), d1 + 1.0, d2 + ParticleUtil.inRange((double)-0.5, (double)0.5), 2, 0.0, 0.0, 0.0, 0.5);
    }
}

