/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.registry;

import alexthw.ars_elemental.common.mob_effects.BubbleShieldEffect;
import alexthw.ars_elemental.common.mob_effects.EnderferenceEffect;
import alexthw.ars_elemental.common.mob_effects.EnthrallEffect;
import alexthw.ars_elemental.common.mob_effects.FrozenEffect;
import alexthw.ars_elemental.common.mob_effects.LifeLinkEffect;
import alexthw.ars_elemental.common.mob_effects.LightningLureEffect;
import alexthw.ars_elemental.common.mob_effects.MagicFireEffect;
import alexthw.ars_elemental.common.mob_effects.OrderEffect;
import alexthw.ars_elemental.common.mob_effects.RepelEffect;
import alexthw.ars_elemental.common.mob_effects.VenomEffect;
import alexthw.ars_elemental.common.mob_effects.WaterGraveEffect;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.lib.LibPotions;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModPotions {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"ars_elemental");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((Registry)BuiltInRegistries.POTION, (String)"ars_elemental");
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_FIRE = EFFECTS.register("hellfire", MagicFireEffect::new);
    public static final DeferredHolder<MobEffect, MobEffect> FROZEN = EFFECTS.register("frozen", FrozenEffect::new);
    public static final DeferredHolder<MobEffect, MobEffect> WATER_GRAVE = EFFECTS.register("watery_grave", WaterGraveEffect::new);
    public static final DeferredHolder<MobEffect, MobEffect> MANA_BUBBLE = EFFECTS.register("mana_shield", BubbleShieldEffect::new);
    public static final DeferredHolder<MobEffect, MobEffect> ENTHRALLED = EFFECTS.register("enthralled", EnthrallEffect::new);
    public static final DeferredHolder<MobEffect, MobEffect> HYMN_OF_ORDER;
    public static final DeferredHolder<MobEffect, LifeLinkEffect> LIFE_LINK;
    public static final DeferredHolder<MobEffect, EnderferenceEffect> ENDERFERENCE;
    public static final DeferredHolder<MobEffect, LightningLureEffect> LIGHTNING_LURE;
    public static final DeferredHolder<MobEffect, RepelEffect> REPEL;
    public static final DeferredHolder<MobEffect, VenomEffect> VENOM;
    public static final DeferredHolder<Potion, Potion> ENDERFERENCE_POTION;
    public static final DeferredHolder<Potion, Potion> LONG_ENDERFERENCE_POTION;
    public static final DeferredHolder<Potion, Potion> SHOCK_POTION;
    public static final DeferredHolder<Potion, Potion> LONG_SHOCK_POTION;

    @SubscribeEvent
    private static void addBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, Items.TWISTING_VINES.asItem(), ENDERFERENCE_POTION);
        builder.addMix(ENDERFERENCE_POTION, Items.GLOWSTONE_DUST, LONG_ENDERFERENCE_POTION);
        builder.addMix(Potions.AWKWARD, ((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem(), SHOCK_POTION);
        builder.addMix(SHOCK_POTION, Items.GLOWSTONE_DUST, LONG_SHOCK_POTION);
    }

    static {
        LIFE_LINK = EFFECTS.register("life_link", LifeLinkEffect::new);
        HYMN_OF_ORDER = EFFECTS.register("hymn_of_order", OrderEffect::new);
        ENDERFERENCE = EFFECTS.register("enderference", EnderferenceEffect::new);
        LIGHTNING_LURE = EFFECTS.register("static_charged", LightningLureEffect::new);
        REPEL = EFFECTS.register("repel", RepelEffect::new);
        VENOM = EFFECTS.register("venom", VenomEffect::new);
        ENDERFERENCE_POTION = POTIONS.register(LibPotions.potion((String)"enderference"), () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(ENDERFERENCE, 400)}));
        LONG_ENDERFERENCE_POTION = POTIONS.register(LibPotions.longPotion((String)"enderference"), () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(ENDERFERENCE, 1200)}));
        SHOCK_POTION = POTIONS.register(LibPotions.potion((String)"shock"), () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(LIGHTNING_LURE, 600)}));
        LONG_SHOCK_POTION = POTIONS.register(LibPotions.longPotion((String)"shock"), () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(LIGHTNING_LURE, 400)}));
    }
}

