/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.spikes.EnchantedDripstoneEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class FallingSpikeRenderer
extends GeoEntityRenderer<EnchantedDripstoneEntity> {
    public FallingSpikeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FallingSpikeGeoModel());
    }

    public FallingSpikeRenderer(EntityRendererProvider.Context renderManager, ResourceLocation texture) {
        super(renderManager, (GeoModel)new FallingSpikeGeoModel(texture));
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, EnchantedDripstoneEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        super.scaleModelForRender(0.5f, 0.5f, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    private static class FallingSpikeGeoModel
    extends GeoModel<EnchantedDripstoneEntity> {
        static final ResourceLocation MODEL = ArsElemental.prefix("geo/spike.geo.json");
        static final ResourceLocation TEXTURE = ArsElemental.prefix("textures/entity/spike.png");
        static final ResourceLocation ANIMATIONS = ArsElemental.prefix("animations/spike.animation.json");
        ResourceLocation AltTexture;

        public FallingSpikeGeoModel() {
        }

        public FallingSpikeGeoModel(ResourceLocation textureLocation) {
            this.AltTexture = textureLocation;
        }

        public ResourceLocation getModelResource(EnchantedDripstoneEntity dripstoneSpikeEntity) {
            return MODEL;
        }

        public ResourceLocation getTextureResource(EnchantedDripstoneEntity dripstoneSpikeEntity) {
            return this.AltTexture != null ? this.AltTexture : TEXTURE;
        }

        public ResourceLocation getAnimationResource(EnchantedDripstoneEntity dripstoneSpikeEntity) {
            return ANIMATIONS;
        }

        public void setCustomAnimations(EnchantedDripstoneEntity animatable, long instanceId, AnimationState<EnchantedDripstoneEntity> animationState) {
            super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
            Vec3 velocity = animatable.getDeltaMovement();
            GeoBone master = this.getAnimationProcessor().getBone("master");
            if (master != null && !velocity.equals((Object)Vec3.ZERO)) {
                Vec3 direction = velocity.normalize();
                float pitch = (float)Math.acos(direction.y);
                float yaw = (float)Math.atan2(direction.x, direction.z);
                if (direction.y < 1.0) {
                    pitch = -pitch;
                }
                master.setRotX(pitch);
                master.setRotY(yaw);
            }
        }
    }
}

