/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CasterTomeData;
import com.hollingsworth.arsnouveau.common.datagen.CasterTomeProvider;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import lyrellion.ars_elemancy.ArsElemancy;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AECasterTomeProvider
extends CasterTomeProvider {
    public AECasterTomeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        Path output = this.generator.getPackOutput().getOutputFolder();
        for (CasterTomeProvider.CasterRecipeWrapper g : this.tomes) {
            Path path = this.getRecipePath(output, g.id().getPath());
            this.saveStable(cache, (JsonElement)CasterTomeData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.toData()).getOrThrow(), path);
        }
    }

    public CasterTomeProvider.CasterRecipeWrapper buildTome(DeferredHolder<Item, ? extends CasterTome> item, String id, String name, Spell spell, String flavorText, ParticleColor particleColor) {
        return new CasterTomeProvider.CasterRecipeWrapper(ArsElemancy.prefix(id + "_tome"), name, spell.serializeRecipe(), item.getId(), flavorText, particleColor.serialize(), ConfiguredSpellSound.DEFAULT);
    }

    protected Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_elemancy/recipe/tomes/" + str + ".json");
    }

    public String getName() {
        return "Ars Elemental Caster Tomes Datagen";
    }
}

