/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.item;

import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.ConjureBiomeRitual;
import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.StructureRitual;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.qther.ars_controle.datagen.ACItemTagProvider;
import dev.qther.ars_controle.mixin.AbstractRitualInvoker;
import dev.qther.ars_controle.packets.clientbound.PacketSyncAssociation;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import dev.qther.ars_controle.util.RenderQueue;
import dev.qther.ars_controle.util.RenderUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortableBrazierRelayItem
extends ModItem {
    private static long LAST_UPDATE = -60L;
    private static final Map<AbstractRitual, Player> rituals = new WeakHashMap<AbstractRitual, Player>();
    AbstractRitual cachedRitual;

    public static void clearCache() {
        LAST_UPDATE = -60L;
        rituals.clear();
    }

    public static Map<AbstractRitual, Player> getRelayedRituals() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return Collections.emptyMap();
        }
        if (LAST_UPDATE + 60L >= (long)server.getTickCount()) {
            return rituals;
        }
        LAST_UPDATE = server.getTickCount();
        rituals.clear();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            for (ItemStack stack : player.getInventory().items) {
                RitualBrazierTile brazier;
                ServerLevel level;
                if (!stack.is(ACRegistry.Items.PORTABLE_BRAZIER_RELAY.asItem())) continue;
                PortableBrazierRelayData data = PortableBrazierRelayData.fromItemStack(stack);
                if (!data.pos.isPresent() || (level = Cached.getLevelByKey((ResourceKey<Level>)data.pos.get().dimension())) == null || (brazier = PortableBrazierRelayItem.getBrazier(null, stack)) == null) continue;
                rituals.put(brazier.ritual, (Player)player);
            }
        }
        return rituals;
    }

    public PortableBrazierRelayItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public Component getName(ItemStack stack) {
        PortableBrazierRelayData data = (PortableBrazierRelayData)stack.get(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
        if (data != null && !data.ritualName.isEmpty()) {
            return Component.translatable((String)"item.ars_controle.portable_brazier_relay.with_ritual", (Object[])new Object[]{Component.translatable((String)data.ritualName)});
        }
        return Component.translatable((String)"item.ars_controle.portable_brazier_relay");
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Optional existingData;
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return super.useOn(context);
        }
        ServerLevel level2 = (ServerLevel)level;
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return super.useOn(context);
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos pos = context.getClickedPos();
        BlockEntity be = level2.getBlockEntity(pos);
        if (!(be instanceof RitualBrazierTile)) {
            return super.useOn(context);
        }
        RitualBrazierTile brazier = (RitualBrazierTile)be;
        if (!PortableBrazierRelayItem.canRelay(brazier.ritual)) {
            PortUtil.sendMessageNoSpam((Entity)player2, (Component)Component.translatable((String)"ars_controle.portable_brazier_relay.blacklisted_ritual", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)brazier.ritual.getRegistryName()))}));
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        PortableBrazierRelayData relayData = PortableBrazierRelayData.fromItemStack(stack);
        RitualBrazierTile currentBrazier = PortableBrazierRelayItem.getBrazier((Entity)player2, stack);
        if (currentBrazier != null) {
            currentBrazier.removeData(ACRegistry.Attachments.RELAY_UUID);
            currentBrazier.removeData(ACRegistry.Attachments.ASSOCIATION);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)new ChunkPos(currentBrazier.getBlockPos()), (CustomPacketPayload)new PacketSyncAssociation(relayData.pos.get(), null), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if ((existingData = be.getExistingData(ACRegistry.Attachments.RELAY_UUID)).isPresent() && relayData.uuid.isPresent() && ((UUID)existingData.get()).equals(relayData.uuid.get())) {
            stack.remove(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            brazier.removeData(ACRegistry.Attachments.RELAY_UUID);
            brazier.removeData(ACRegistry.Attachments.ASSOCIATION);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)new ChunkPos(brazier.getBlockPos()), (CustomPacketPayload)new PacketSyncAssociation(new GlobalPos(level2.dimension(), pos), null), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PortUtil.sendMessageNoSpam((Entity)player2, (Component)Component.translatable((String)"ars_controle.target.set.none"));
        } else {
            PortableBrazierRelayData data = PortableBrazierRelayData.of(new GlobalPos(level2.dimension(), pos), brazier.ritual);
            UUID uuid = data.uuid.get();
            data.write(stack);
            brazier.setData(ACRegistry.Attachments.RELAY_UUID, (Object)uuid);
            brazier.setData(ACRegistry.Attachments.ASSOCIATION, (Object)player2.getUUID());
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)new ChunkPos(brazier.getBlockPos()), (CustomPacketPayload)new PacketSyncAssociation(new GlobalPos(level2.dimension(), pos), player2.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PortUtil.sendMessageNoSpam((Entity)player2, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{pos.toShortString(), level2.dimension().location().toString()}));
        }
        return super.useOn(context);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        AbstractRitual ritual;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)player.getMainHandItem()) && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)player.getOffhandItem())) {
                return;
            }
            PortableBrazierRelayData data = (PortableBrazierRelayData)stack.get(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            if (data != null && data.pos.isPresent() && data.pos.get().dimension().equals(level.dimension())) {
                RenderQueue.enqueue(RenderQueue.RenderTask.until(event -> {
                    if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                        RenderUtil.renderBlockOutline(event, data.pos.get().pos());
                    }
                }, level.getGameTime()));
            }
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.getGameTime() % 20L == 0L) {
            RitualBrazierTile brazier = PortableBrazierRelayItem.getBrazier(entity, stack);
            if (brazier == null) {
                return;
            }
            if (brazier.isRitualDone()) {
                return;
            }
            ResourceLocation regName = brazier.ritual.getRegistryName();
            PortableBrazierRelayData data = (PortableBrazierRelayData)stack.get(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            if (data != null) {
                Optional brazierAssoc;
                String ritualName = "item." + regName.getNamespace() + "." + regName.getPath();
                if (!data.ritualName.equals(ritualName)) {
                    stack.set(ACRegistry.Components.PORTABLE_BRAZIER_RELAY, (Object)PortableBrazierRelayData.of(data.pos().get(), ritualName));
                }
                if ((brazierAssoc = brazier.getExistingData(ACRegistry.Attachments.ASSOCIATION)).isEmpty() || !((UUID)brazierAssoc.get()).equals(entity.getUUID())) {
                    brazier.setData(ACRegistry.Attachments.ASSOCIATION, (Object)entity.getUUID());
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(brazier.getBlockPos()), (CustomPacketPayload)new PacketSyncAssociation(new GlobalPos(serverLevel.dimension(), brazier.getBlockPos()), entity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            this.cachedRitual = brazier.ritual;
        }
        if ((ritual = this.cachedRitual) == null || !ritual.isRunning()) {
            return;
        }
        ((AbstractRitualInvoker)ritual).invokeTick();
    }

    public static RitualBrazierTile getBrazier(@Nullable Entity entity, ItemStack stack) {
        PortableBrazierRelayData data = PortableBrazierRelayData.fromItemStack(stack);
        if (data.pos.isEmpty() || data.uuid.isEmpty()) {
            return null;
        }
        GlobalPos target = data.pos.get();
        ResourceKey targetDim = target.dimension();
        BlockPos targetPos = target.pos();
        ServerLevel targetLevel = Cached.getLevelByKey((ResourceKey<Level>)targetDim);
        if (targetLevel == null) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_dimension"));
            stack.remove(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            return null;
        }
        if (!targetLevel.isLoaded(targetPos)) {
            return null;
        }
        BlockEntity be = targetLevel.getBlockEntity(targetPos);
        if (!(be instanceof RitualBrazierTile)) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            stack.remove(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            return null;
        }
        RitualBrazierTile brazier = (RitualBrazierTile)be;
        if (brazier.ritual == null || entity != null && !brazier.getExistingData(ACRegistry.Attachments.RELAY_UUID).map(u -> data.uuid.get().equals(u)).orElse(false).booleanValue()) {
            stack.remove(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            return null;
        }
        if (!PortableBrazierRelayItem.canRelay(brazier.ritual)) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"ars_controle.portable_brazier_relay.blacklisted_ritual", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)brazier.ritual.getRegistryName()))}));
            stack.remove(ACRegistry.Components.PORTABLE_BRAZIER_RELAY);
            brazier.removeData(ACRegistry.Attachments.RELAY_UUID);
            brazier.removeData(ACRegistry.Attachments.ASSOCIATION);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)targetLevel, (ChunkPos)new ChunkPos(brazier.getBlockPos()), (CustomPacketPayload)new PacketSyncAssociation(target, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return null;
        }
        return brazier;
    }

    public static boolean canRelay(AbstractRitual ritual) {
        if (ritual instanceof ConjureBiomeRitual || ritual instanceof StructureRitual || ritual instanceof FeaturePlacementRitual) {
            return false;
        }
        RitualTablet tablet = (RitualTablet)RitualRegistry.getRitualItemMap().get(ritual.getRegistryName());
        if (tablet == null) {
            return false;
        }
        return !BuiltInRegistries.ITEM.wrapAsHolder((Object)tablet).is(ACItemTagProvider.RITUAL_BLACKLIST);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        PortableBrazierRelayData data = PortableBrazierRelayData.fromItemStack(stack);
        if (data.pos.isEmpty()) {
            tooltip2.add((Component)Component.translatable((String)"ars_controle.target.get.none"));
        } else {
            GlobalPos pos = data.pos.get();
            tooltip2.add((Component)Component.translatable((String)"ars_controle.target.get.block", (Object[])new Object[]{pos.pos().toShortString(), pos.dimension().location().toString()}));
        }
    }

    public record PortableBrazierRelayData(@NotNull Optional<GlobalPos> pos, @NotNull Optional<UUID> uuid, String ritualName) {
        public static final Codec<PortableBrazierRelayData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.optionalFieldOf("pos").forGetter(PortableBrazierRelayData::pos), (App)UUIDUtil.CODEC.optionalFieldOf("uuid").forGetter(PortableBrazierRelayData::uuid), (App)Codec.STRING.fieldOf("target_name").forGetter(PortableBrazierRelayData::ritualName)).apply((Applicative)instance, PortableBrazierRelayData::new));
        public static final StreamCodec<FriendlyByteBuf, PortableBrazierRelayData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), PortableBrazierRelayData::pos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), PortableBrazierRelayData::uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8, PortableBrazierRelayData::ritualName, PortableBrazierRelayData::new);

        public static PortableBrazierRelayData empty() {
            return new PortableBrazierRelayData(Optional.empty(), Optional.empty(), "");
        }

        public static PortableBrazierRelayData of(GlobalPos pos, UUID uuid, String ritualName) {
            return new PortableBrazierRelayData(Optional.of(pos), Optional.of(uuid), ritualName);
        }

        public static PortableBrazierRelayData of(GlobalPos pos, UUID uuid, AbstractRitual ritual) {
            ResourceLocation regName = ritual.getRegistryName();
            return PortableBrazierRelayData.of(pos, uuid, "item." + regName.getNamespace() + "." + regName.getPath());
        }

        public static PortableBrazierRelayData of(GlobalPos pos, String ritualName) {
            return PortableBrazierRelayData.of(pos, UUID.randomUUID(), ritualName);
        }

        public static PortableBrazierRelayData of(GlobalPos pos, AbstractRitual ritual) {
            return PortableBrazierRelayData.of(pos, UUID.randomUUID(), ritual);
        }

        public static PortableBrazierRelayData fromItemStack(@NotNull ItemStack stack) {
            return (PortableBrazierRelayData)stack.getOrDefault((DataComponentType)ACRegistry.Components.PORTABLE_BRAZIER_RELAY.get(), (Object)PortableBrazierRelayData.empty());
        }

        public PortableBrazierRelayData write(@NotNull ItemStack stack) {
            return (PortableBrazierRelayData)stack.set(ACRegistry.Components.PORTABLE_BRAZIER_RELAY, (Object)this);
        }
    }
}

