/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.cc;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.qther.ars_controle.block.tile.WarpingSpellPrismTile;
import dev.qther.ars_controle.util.Cached;
import dev.qther.ars_controle.util.XYZMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WarpingSpellPrismPeripheral
implements IPeripheral {
    private final String type;
    private final WarpingSpellPrismTile owner;

    public WarpingSpellPrismPeripheral(String type, WarpingSpellPrismTile owner) {
        this.type = type;
        this.owner = owner;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other instanceof WarpingSpellPrismPeripheral) {
            WarpingSpellPrismPeripheral peri = (WarpingSpellPrismPeripheral)other;
            return this.owner == peri.owner;
        }
        return false;
    }

    public final void setTarget(BlockPos pos) {
        this.owner.setBlock((ResourceKey<Level>)this.owner.getLevel().dimension(), pos);
    }

    public final void setTarget(String level, BlockPos pos) throws LuaException {
        ServerLevel l = Cached.getLevelByName(level);
        if (l == null) {
            throw new LuaException("Invalid level: " + level);
        }
        this.owner.setBlock((ResourceKey<Level>)l.dimension(), pos);
    }

    @LuaFunction(mainThread=true)
    public final void setTargetWithLevel(String level, int x, int y, int z) throws LuaException {
        this.setTarget(level, new BlockPos(x, y, z));
    }

    @LuaFunction(mainThread=true)
    public final void setTarget(int x, int y, int z) {
        this.setTarget(new BlockPos(x, y, z));
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public final Map<String, Object> target() {
        HitResult hit = this.owner.getHitResult();
        if (hit == null) {
            return null;
        }
        Object2ObjectArrayMap map = new Object2ObjectArrayMap(3);
        map.put((Object)"type", (Object)hit.getType().toString().toLowerCase(Locale.ENGLISH));
        Vec3 loc = hit.getLocation();
        map.put((Object)"location", XYZMap.of(loc));
        if (hit instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)hit;
            BlockPos bp = bhr.getBlockPos();
            Object2ObjectArrayMap inner = new Object2ObjectArrayMap(2);
            inner.put((Object)"pos", XYZMap.of(bp));
            inner.put((Object)"level", (Object)this.owner.getTargetLevel().dimension().location().toString());
            map.put((Object)"block", (Object)inner);
        } else if (hit instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)hit;
            Entity e = ehr.getEntity();
            Object2ObjectArrayMap inner = new Object2ObjectArrayMap(11);
            inner.put((Object)"type", (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType()).toString());
            inner.put((Object)"name", (Object)e.getName().getString());
            inner.put((Object)"pos", XYZMap.of(e.getPosition(1.0f)));
            inner.put((Object)"eyePos", XYZMap.of(e.getEyePosition()));
            inner.put((Object)"level", (Object)e.level().dimension().location().toString());
            inner.put((Object)"yaw", (Object)Float.valueOf(Mth.wrapDegrees((float)e.getYRot())));
            inner.put((Object)"pitch", (Object)Float.valueOf(Mth.wrapDegrees((float)e.getXRot())));
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                inner.put((Object)"health", (Object)Float.valueOf(le.getHealth()));
                inner.put((Object)"absorption", (Object)Float.valueOf(le.getAbsorptionAmount()));
                Collection effectList = le.getActiveEffects();
                Object2IntArrayMap effectMap = new Object2IntArrayMap(effectList.size());
                for (MobEffectInstance effect : effectList) {
                    effectMap.put((Object)effect.getDescriptionId(), effect.getAmplifier());
                }
                inner.put((Object)"effects", (Object)effectMap);
            }
            map.put((Object)"entity", (Object)inner);
        }
        return map;
    }

    @LuaFunction(mainThread=true)
    public final int sourceNeeded() {
        return this.owner.getSourceRequired(this.owner.getHitResult());
    }

    public Object getTarget() {
        return this.owner;
    }
}

