/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.block.tile.IDimensionalHighlighter;
import dev.qther.ars_controle.config.ACServerConfig;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WarpingSpellPrismTile
extends ModdedTile
implements IWandable,
IDimensionalHighlighter {
    public WarpingSpellPrismTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACRegistry.Tiles.WARPING_SPELL_PRISM.get(), pos, state);
    }

    @Nullable
    public HitResult getHitResult() {
        if (this.level == null || this.level.isClientSide) {
            return null;
        }
        GlobalPos blockPos = this.getExistingData(ACRegistry.Attachments.GLOBAL_POS_TARGET).orElse(null);
        if (blockPos != null) {
            Vec3 pos = blockPos.pos().getCenter();
            return new BlockHitResult(pos, Direction.DOWN, blockPos.pos(), true);
        }
        UUID uuid = this.getExistingData(ACRegistry.Attachments.ENTITY_TARGET).orElse(null);
        Entity entity = null;
        if (uuid != null) {
            entity = Cached.getEntityByUUID(uuid);
        }
        if (entity == null) {
            return null;
        }
        return new EntityHitResult(entity, entity.getEyePosition());
    }

    public void setBlock(@Nullable ResourceKey<Level> level, @Nullable BlockPos block) {
        if (level == null || block == null) {
            this.removeData(ACRegistry.Attachments.GLOBAL_POS_TARGET);
        } else {
            this.setData(ACRegistry.Attachments.GLOBAL_POS_TARGET, new GlobalPos(level, block));
            this.removeData(ACRegistry.Attachments.ENTITY_TARGET);
        }
        this.setChanged();
    }

    @Nullable
    public ServerLevel getTargetLevel() {
        if (this.level == null || this.level.isClientSide) {
            return null;
        }
        GlobalPos pos = this.getExistingData(ACRegistry.Attachments.GLOBAL_POS_TARGET).orElse(null);
        if (pos != null) {
            return Cached.getLevelByKey((ResourceKey<Level>)pos.dimension());
        }
        Entity entity = this.getEntity();
        if (entity != null) {
            return (ServerLevel)entity.level();
        }
        return null;
    }

    public void setEntityUUID(@Nullable UUID uuid) {
        if (uuid == null) {
            this.removeData(ACRegistry.Attachments.ENTITY_TARGET);
        } else {
            this.setData(ACRegistry.Attachments.ENTITY_TARGET, uuid);
            this.removeData(ACRegistry.Attachments.GLOBAL_POS_TARGET);
        }
        this.setChanged();
    }

    @Nullable
    public UUID getEntityUUID() {
        return this.getExistingData(ACRegistry.Attachments.ENTITY_TARGET).orElse(null);
    }

    @Nullable
    public Entity getEntity() {
        UUID uuid = this.getEntityUUID();
        return uuid == null ? null : Cached.getEntityByUUID(uuid);
    }

    public int getSourceRequired(HitResult hitResult) {
        if (hitResult == null) {
            return 0;
        }
        double distSqr = 0.0;
        int dimCost = 0;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult b = (BlockHitResult)hitResult;
            distSqr = b.getBlockPos().getCenter().distanceToSqr(this.getBlockPos().getCenter());
            if (this.getTargetLevel() != this.level) {
                dimCost = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_DIMENSION.get();
            }
        } else if (hitResult instanceof EntityHitResult) {
            EntityHitResult e = (EntityHitResult)hitResult;
            distSqr = e.getLocation().distanceToSqr(this.getBlockPos().getCenter());
            if (this.getTargetLevel() != this.level) {
                dimCost = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_DIMENSION.get();
            }
        }
        Integer costMinDistance = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_MIN_DISTANCE.get();
        int costMinDistanceSqr = costMinDistance * costMinDistance;
        Double costPerBlock = (Double)ACServerConfig.SERVER.WARPING_SPELL_PRISM_COST_PER_BLOCK.get();
        if (distSqr > (double)costMinDistanceSqr) {
            int maxCost = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_MAX_SOURCE_COST.get();
            if (maxCost < 0) {
                maxCost = Integer.MAX_VALUE;
            }
            return Math.max(0, (int)Math.min((double)maxCost, (double)dimCost + Math.sqrt(distSqr - (double)costMinDistanceSqr) * costPerBlock));
        }
        return Math.max(0, dimCost);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        CompoundTag data = this.getPersistentData();
        if (data.contains("block", 4) && data.contains("dimension", 8)) {
            long block = data.getLong("block");
            String dimension = data.getString("dimension");
            this.setData(ACRegistry.Attachments.GLOBAL_POS_TARGET, new GlobalPos(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimension)), BlockPos.of((long)block)));
        } else if (data.contains("entity", 11)) {
            UUID entity = data.getUUID("entity");
            this.setData(ACRegistry.Attachments.ENTITY_TARGET, entity);
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag data = this.getPersistentData();
        data.remove("entity");
        data.remove("block");
        data.remove("dimension");
        super.saveAdditional(tag, registries);
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            this.setBlock((ResourceKey<Level>)storedPos.dimension(), storedPos.pos());
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.pos().toShortString(), storedPos.dimension().location().toString()}));
            return IWandable.Result.SUCCESS;
        }
        if (storedEntity != null) {
            if (storedEntity instanceof Player && !player.isCreative() && !((Boolean)ACServerConfig.SERVER.WARPING_SPELL_PRISM_ALLOW_LINKING_OTHER_PLAYERS.get()).booleanValue() && !storedEntity.getUUID().equals(player.getUUID())) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.fail.other_player"));
                return IWandable.Result.FAIL;
            }
            this.setEntityUUID(storedEntity.getUUID());
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.entity", (Object[])new Object[]{storedEntity.getDisplayName(), storedEntity.level().dimension().location().toString()}));
            return IWandable.Result.SUCCESS;
        }
        return IWandable.Result.FAIL;
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            ResourceKey dim = player.level().dimension();
            this.setBlock((ResourceKey<Level>)dim, storedPos);
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.toShortString(), dim.location().toString()}));
            return;
        }
        if (storedEntity != null) {
            if (storedEntity instanceof Player && !player.isCreative() && !((Boolean)ACServerConfig.SERVER.WARPING_SPELL_PRISM_ALLOW_LINKING_OTHER_PLAYERS.get()).booleanValue() && !storedEntity.getUUID().equals(player.getUUID())) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.fail.other_player"));
                return;
            }
            this.setEntityUUID(storedEntity.getUUID());
            this.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.entity", (Object[])new Object[]{storedEntity.getDisplayName(), storedEntity.level().dimension().location().toString()}));
        }
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        HitResult target = this.getHitResult();
        return target == null ? List.of() : List.of(new ColorPos(target.getLocation()));
    }

    @Override
    public List<ColorPos> getWandHighlight(Level level, List<ColorPos> list) {
        HitResult target;
        ServerLevel dim = this.getTargetLevel();
        if (dim == level && (target = this.getHitResult()) != null) {
            list.add(new ColorPos(target.getLocation()));
        }
        return list;
    }
}

