/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.spell.filter;

import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.registry.ACNames;
import dev.qther.ars_controle.spell.filter.FilterRandom;
import dev.qther.ars_controle.spell.filter.FilterYLevel;
import dev.qther.ars_controle.spell.filter.IAdaptiveFilter;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.booleans.Boolean2BooleanFunction;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterUnary
extends AbstractFilter
implements IAdaptiveFilter {
    public static final FilterUnary NOT = new FilterUnary(ACNames.GLYPH_FILTER_NOT, "Filter: NOT", "Only resolves the spell if the result of the next Filter is false.", a -> !a);
    private final Boolean2BooleanFunction op;
    public SpellResolver res;
    private final String bookDescription;

    private FilterUnary(String id, String name, String bookDescription, Boolean2BooleanFunction op) {
        super(ArsControle.prefix(id), name);
        this.op = op;
        this.bookDescription = bookDescription;
    }

    public String getBookDescription() {
        return this.bookDescription;
    }

    public Integer getTypeIndex() {
        return 15;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.res = resolver;
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.res = resolver;
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public boolean shouldResolveOnBlock(BlockHitResult target, Level level) {
        if (this.res == null || level.isClientSide) {
            return false;
        }
        Pair<Integer, IFilter> f = this.getFilter();
        if (f == null) {
            return false;
        }
        IFilter filter = (IFilter)f.second();
        int idx = this.res.spellContext.getCurrentIndex();
        this.res.spellContext.setCurrentIndex(idx + (Integer)f.first());
        try {
            return this.op.get(filter.shouldResolveOnBlock(target, level));
        }
        catch (Exception e) {
            LivingEntity livingEntity = this.res.spellContext.getUnwrappedCaster();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_controle.glyph.error.generic.error_at_position", (Object[])new Object[]{Component.translatable((String)this.getLocalizationKey()), idx}));
            }
            ArsControle.LOGGER.error("Failed to resolve binary filter", (Throwable)e);
            return false;
        }
    }

    public boolean shouldResolveOnEntity(EntityHitResult target, Level level) {
        if (this.res == null || level.isClientSide) {
            return false;
        }
        Pair<Integer, IFilter> f = this.getFilter();
        if (f == null) {
            return false;
        }
        IFilter filter = (IFilter)f.second();
        int idx = this.res.spellContext.getCurrentIndex();
        this.res.spellContext.setCurrentIndex(idx + (Integer)f.first());
        try {
            return this.op.get(filter.shouldResolveOnEntity(target, level));
        }
        catch (Exception e) {
            LivingEntity livingEntity = this.res.spellContext.getUnwrappedCaster();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_controle.glyph.error.generic.error_at_position", (Object[])new Object[]{Component.translatable((String)this.getLocalizationKey()), idx}));
            }
            ArsControle.LOGGER.error("Failed to resolve binary filter", (Throwable)e);
            return false;
        }
    }

    @Nullable
    public Pair<Integer, IFilter> getFilter() {
        int idx = this.res.spellContext.getCurrentIndex();
        Spell spell = this.res.spell;
        LivingEntity caster = this.res.spellContext.getUnwrappedCaster();
        if (spell.size() < idx + 1) {
            return null;
        }
        AbstractSpellPart next = spell.get(idx);
        if (!(next instanceof IFilter)) {
            return null;
        }
        IFilter afst = (IFilter)next;
        List firstAugments = spell.getAugments(idx, caster);
        int skip = firstAugments.size() + 1;
        if (next instanceof FilterYLevel) {
            FilterYLevel ynext = (FilterYLevel)next;
            ynext.y = (int)(this.res.spellContext.getCaster().getPosition().y - 1.0);
        }
        if (next instanceof FilterRandom) {
            FilterRandom rnext = (FilterRandom)next;
            SpellContext newCtx = this.res.spellContext.makeChildContext();
            SpellResolver newRes = this.res.getNewResolver(newCtx);
            SpellStats stats = new SpellStats.Builder().setAugments(firstAugments).addItemsFromEntity(caster).build((AbstractSpellPart)rnext, newRes.hitResult, caster.level(), caster, newCtx);
            rnext.chance = FilterRandom.calculateChance(stats.getAmpMultiplier());
        }
        return Pair.of((Object)skip, (Object)afst);
    }
}

