/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.cc;

import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.qther.ars_controle.block.tile.ScrollHolderTile;
import dev.qther.ars_controle.util.XYMap;
import dev.qther.ars_controle.util.XYZMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public class ScrollHolderPeripheral
implements IPeripheral {
    private final String type;
    private final ScrollHolderTile owner;

    public ScrollHolderPeripheral(String type, ScrollHolderTile owner) {
        this.type = type;
        this.owner = owner;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other instanceof ScrollHolderPeripheral) {
            ScrollHolderPeripheral peri = (ScrollHolderPeripheral)other;
            return this.owner == peri.owner;
        }
        return false;
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public final Map<String, Object> target() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap(4);
        ItemStack scroll = this.owner.getItem(0);
        WarpScrollData data = (WarpScrollData)scroll.get((Supplier)DataComponentRegistry.WARP_SCROLL);
        if (data == null || !data.isValid()) {
            return null;
        }
        map.put((Object)"stable", (Object)data.crossDim());
        map.put((Object)"dimension", (Object)data.dimension());
        map.put((Object)"pos", XYZMap.of((BlockPos)data.pos().get()));
        map.put((Object)"rotation", XYMap.of(data.rotation()));
        return map;
    }

    public Object getTarget() {
        return this.owner;
    }
}

