/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.wixie;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.SingleRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class EnchantingApparatusRecipeWrapper
extends MultiRecipeWrapper {
    public static Map<Item, MultiRecipeWrapper> RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();

    public static MultiRecipeWrapper fromStack(ItemStack stack, Level level) {
        if (RECIPE_CACHE.containsKey(stack.getItem())) {
            return RECIPE_CACHE.get(stack.getItem());
        }
        EnchantingApparatusRecipeWrapper wrapper = new EnchantingApparatusRecipeWrapper();
        if (level.getServer() == null) {
            return wrapper;
        }
        for (RecipeHolder recipe : level.getServer().getRecipeManager().getRecipes()) {
            Recipe recipe2 = recipe.value();
            if (!(recipe2 instanceof EnchantingApparatusRecipe)) continue;
            EnchantingApparatusRecipe apparatusRecipe = (EnchantingApparatusRecipe)recipe2;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(apparatusRecipe.pedestalItems());
            ItemStack result = apparatusRecipe.result();
            if (apparatusRecipe instanceof EnchantmentRecipe) {
                EnchantmentRecipe enchantmentRecipe = (EnchantmentRecipe)apparatusRecipe;
                ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
                Optional enchantment = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(enchantmentRecipe.enchantmentKey);
                if (enchantment.isEmpty() || !((Holder.Reference)enchantment.get()).isBound() || enchantments.getLevel((Holder)enchantment.get()) != enchantmentRecipe.enchantLevel) {
                    continue;
                }
            } else {
                if (result.getItem() != stack.getItem()) continue;
                ingredients.add(apparatusRecipe.reagent());
            }
            wrapper.addRecipe(ingredients, result, recipe.value());
        }
        RECIPE_CACHE.put(stack.getItem(), wrapper);
        return wrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public List<ItemStack> getItemsNeeded(Map<Item, Integer> inventory, Level world, BlockPos pos, SingleRecipe recipe) {
        List otherItems;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Recipe recipe2 = recipe.iRecipe;
        if (recipe2 instanceof EnchantmentRecipe) {
            EnchantmentRecipe enchantmentRecipe = (EnchantmentRecipe)recipe2;
            BlockEntity tile = world.getBlockEntity(pos);
            ArrayList<FilterableItemHandler> filterables = new ArrayList<FilterableItemHandler>();
            if (!(tile instanceof WixieCauldronTile)) return null;
            WixieCauldronTile cauldronTile = (WixieCauldronTile)tile;
            if (!(world instanceof ServerLevel)) return null;
            ServerLevel serverLevel = (ServerLevel)world;
            for (BlockPos p : cauldronTile.getInventories()) {
                IItemHandler handler;
                BlockEntity be = world.getBlockEntity(p);
                if (be == null || (handler = (IItemHandler)serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, p, serverLevel.getBlockState(p), be, null)) == null) continue;
                filterables.add(new FilterableItemHandler(handler));
            }
            InventoryManager inventoryManager = new InventoryManager(filterables);
            SlotReference slot = inventoryManager.findItem(is -> is.is(Items.BOOK) || enchantmentRecipe.doesReagentMatch(new ApparatusRecipeInput(is, List.of(), null), (Level)serverLevel, null), InteractType.EXTRACT);
            if (slot.isEmpty()) {
                return null;
            }
            IItemHandler foundHandler = slot.getHandler();
            if (foundHandler == null) {
                return null;
            }
            ItemStack found = foundHandler.getStackInSlot(slot.getSlot()).copy();
            items.add(found);
            ItemStack output = found.getItem() == Items.BOOK ? new ItemStack((ItemLike)Items.ENCHANTED_BOOK) : found.copy();
            ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)output));
            Optional enchantment = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(enchantmentRecipe.enchantmentKey);
            if (enchantment.isEmpty() || !((Holder.Reference)enchantment.get()).isBound()) {
                return null;
            }
            enchantments.set((Holder)enchantment.get(), enchantmentRecipe.enchantLevel);
            EnchantmentHelper.setEnchantments((ItemStack)output, (ItemEnchantments)enchantments.toImmutable());
            recipe.outputStack = output;
        }
        if ((otherItems = super.getItemsNeeded(inventory, world, pos, recipe)) == null) {
            return null;
        }
        items.addAll(otherItems);
        return items;
    }
}

