/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.datagen.tags.ItemTagDatagen;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CodexEntry
extends Item {
    public CodexEntry() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return super.use(level, player, usedHand);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ANPlayerDataCap playerCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)player);
        if (playerCap == null) {
            return super.use(level, player, usedHand);
        }
        List<AbstractSpellPart> glyphs = this.getPossibleGlyphs((IPlayerCap)playerCap).filter(this::isValidGlyph).toList();
        if (glyphs.isEmpty()) {
            int i = this.getExpAmount(level.random);
            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)player.position(), (int)i);
            player.sendSystemMessage((Component)Component.translatable((String)"chat.ars_additions.codex_entry.congratulations"));
            player.sendSystemMessage((Component)Component.translatable((String)"chat.ars_additions.codex_entry.no_glyphs"));
        } else {
            AbstractSpellPart glyph = this.getRandomGlyph(glyphs, level.random);
            playerCap.unlockGlyph(glyph);
            CapabilityRegistry.EventHandler.syncPlayerCap((Player)player);
            player.sendSystemMessage((Component)Component.literal((String)("Unlocked " + glyph.getName())));
        }
        player.getItemInHand(usedHand).consume(1, (LivingEntity)player);
        return super.use(level, player, usedHand);
    }

    public AbstractSpellPart getRandomGlyph(List<AbstractSpellPart> glyphs, RandomSource random) {
        return glyphs.get(random.nextInt(0, glyphs.size()));
    }

    public Stream<AbstractSpellPart> getPossibleGlyphs(IPlayerCap playerCap) {
        List startingSpells = GlyphRegistry.getDefaultStartingSpells();
        return GlyphRegistry.getSpellpartMap().values().stream().filter(Config::isGlyphEnabled).filter(glyph -> !new ItemStack((ItemLike)glyph.getGlyph()).is(ItemTagDatagen.FORGOTTEN_KNOWLEDGE_GLYPHS)).filter(glyph -> !startingSpells.contains(glyph)).filter(glyph -> !playerCap.knowsGlyph(glyph));
    }

    public int getExpAmount(RandomSource random) {
        return 55;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"chat.ars_additions.codex_entry.lore", (Object[])new Object[]{this.getTier().value}));
    }

    public SpellTier getTier() {
        return SpellTier.ONE;
    }

    public boolean isValidGlyph(AbstractSpellPart glyph) {
        return glyph.getConfigTier() == this.getTier();
    }
}

