/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.blocks.AviaryBlock;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;

public class AnimalPenBlockRegistry {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"animal_pen", (ResourceKey)Registries.BLOCK);
    public static final Map<WoodType, RegistrySupplier<Block>> ANIMAL_PENS = new HashMap<WoodType, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> AQUARIUM = AnimalPenBlockRegistry.registerBlock("aquarium_block", () -> new AquariumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).strength(1.0f).sound(SoundType.GLASS).noOcclusion()));
    public static final RegistrySupplier<Block> AVIARY = AnimalPenBlockRegistry.registerBlock("aviary", () -> new AviaryBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).strength(1.0f).sound(SoundType.GLASS).noOcclusion()));

    public static void register() {
        REGISTRY.register();
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = REGISTRY.register(name, block);
        AnimalPenBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block) {
        return AnimalPensItemRegistry.REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().arch$tab(AnimalPensCreativeTabRegistry.ANIMAL_PEN_TAB)));
    }

    public static void registerPen(WoodType woodType, MapColor mapColor, FeatureFlag ... flags) {
        String woodName = woodType.name().toLowerCase();
        if (woodType.name().contains(":")) {
            woodName = woodName.replaceAll(":", "_");
        }
        RegistrySupplier<Block> block = AnimalPenBlockRegistry.registerBlock("animal_pen_" + woodName, () -> new AnimalPenBlock(BlockBehaviour.Properties.of().mapColor(mapColor).strength(1.0f).sound(woodType.soundType()).noOcclusion().requiredFeatures(flags)));
        ANIMAL_PENS.put(woodType, block);
    }

    static {
        AnimalPenBlockRegistry.registerPen(WoodType.OAK, MapColor.WOOD, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.SPRUCE, MapColor.PODZOL, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.BIRCH, MapColor.SAND, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.ACACIA, MapColor.COLOR_GRAY, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.JUNGLE, MapColor.DIRT, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.DARK_OAK, MapColor.COLOR_BROWN, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.CRIMSON, MapColor.CRIMSON_STEM, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.WARPED, MapColor.WARPED_STEM, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.MANGROVE, MapColor.COLOR_RED, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.BAMBOO, MapColor.COLOR_YELLOW, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.CHERRY, MapColor.TERRACOTTA_GRAY, new FeatureFlag[0]);
    }
}

